/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes;

import aroma1997.core.coremod.MCPNames;
import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.IRecipePart;
import aroma1997.core.recipes.ISpecialOutput;
import aroma1997.core.recipes.ShapedAromicRecipe;
import aroma1997.core.recipes.ShapelessAromicRecipe;
import aroma1997.core.recipes.parts.IngredientRecipePart;
import aroma1997.core.recipes.parts.RecipePartClass;
import aroma1997.core.recipes.parts.RecipePartFluid;
import aroma1997.core.recipes.parts.RecipePartIngredient;
import aroma1997.core.recipes.parts.RecipePartNormal;
import aroma1997.core.recipes.parts.RecipePartOredict;
import aroma1997.core.util.AromaRegistry;
import aroma1997.core.util.ItemUtil;
import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeUtil {
    private static Map<ResourceLocation, IRecipe> getRecipeMap() {
        return (Map)ReflectionHelper.getPrivateValue(CraftingManager.class, null, (String[])new String[]{MCPNames.field("field_193380_a")});
    }

    public static List<ResourceLocation> unregisterRecipe(IRecipe recipe) {
        Map<ResourceLocation, IRecipe> recipes = RecipeUtil.getRecipeMap();
        ArrayList<ResourceLocation> locationsToRemove = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, IRecipe> e : recipes.entrySet()) {
            if (!e.getValue().equals(recipe)) continue;
            locationsToRemove.add(e.getKey());
        }
        for (ResourceLocation loc : locationsToRemove) {
            recipes.remove(loc);
        }
        return locationsToRemove;
    }

    public static void unregisterRecipe(ResourceLocation loc) {
        RecipeUtil.getRecipeMap().remove(loc);
    }

    public static void unregisterRecipe(List<IRecipe> list) {
        for (IRecipe recipe : list) {
            RecipeUtil.unregisterRecipe(recipe);
        }
    }

    public static List<IRecipe> getRecipes(ItemStack item) {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        Iterator<IRecipe> iterator = RecipeUtil.getRecipeMap().values().iterator();
        while (iterator.hasNext()) {
            IRecipe o;
            IRecipe recipe = o = iterator.next();
            if (!ItemUtil.areItemsSameMatching(recipe.func_77571_b(), item, ItemUtil.IItemMatchCriteria.WILDCARD)) continue;
            list.add(recipe);
        }
        return list;
    }

    public static <E extends IRecipe> List<E> getRecipes(ItemStack item, Class<E> clazz) {
        List<IRecipe> list = RecipeUtil.getRecipes(item);
        ArrayList<IRecipe> ret = new ArrayList<IRecipe>();
        for (IRecipe recipe : list) {
            if (!clazz.isInstance(recipe)) continue;
            ret.add(recipe);
        }
        return ret;
    }

    public static void unregisterRecipe(ItemStack item) {
        RecipeUtil.unregisterRecipe(RecipeUtil.getRecipes(item));
    }

    public static IAromicRecipe createAromicRecipeFrom(IRecipe recipe) {
        if (recipe instanceof IAromicRecipe) {
            return (IAromicRecipe)recipe;
        }
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes r = (ShapedRecipes)recipe;
            ShapedAromicRecipe ret = new ShapedAromicRecipe();
            ret.height = r.field_77577_c;
            ret.width = r.field_77576_b;
            ret.input = new IRecipePart[r.field_77574_d.size()];
            for (int i = 0; i < ret.input.length; ++i) {
                ret.input[i] = new RecipePartIngredient((Ingredient)r.field_77574_d.get(i));
            }
            ret.output = r.func_77571_b();
            return ret;
        }
        if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes r = (ShapelessRecipes)recipe;
            ShapelessAromicRecipe ret = new ShapelessAromicRecipe(r.func_77571_b(), false, r.field_77579_b.toArray());
            return ret;
        }
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe r = (ShapedOreRecipe)recipe;
            ShapedAromicRecipe ret = new ShapedAromicRecipe();
            NonNullList o = r.func_192400_c();
            ret.input = new IRecipePart[o.size()];
            for (int i = 0; i < ret.input.length; ++i) {
                ret.input[i] = new RecipePartIngredient((Ingredient)o.get(i));
            }
            ret.output = r.func_77571_b();
            ret.width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)r, (String[])new String[]{"width"});
            ret.height = ret.input.length / ret.width;
            return ret;
        }
        if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe r = (ShapelessOreRecipe)recipe;
            ShapelessAromicRecipe ret = new ShapelessAromicRecipe(r.func_77571_b(), r.func_192400_c().toArray());
            return ret;
        }
        throw new IllegalArgumentException("Unsupported conversion recipe. " + recipe.func_77571_b().toString() + " " + recipe.getClass());
    }

    public static void hideRecipe(IRecipe recipe) {
        IAromicRecipe arecipe = RecipeUtil.createAromicRecipeFrom(recipe);
        arecipe.setHidden(true);
        if (recipe != arecipe) {
            List<ResourceLocation> locations = RecipeUtil.unregisterRecipe(recipe);
            for (ResourceLocation loc : locations) {
                AromaRegistry.registerRecipe(loc, arecipe);
            }
        }
    }

    public static IRecipePart getRecipePart(Object o) {
        if (o instanceof IngredientRecipePart) {
            return ((IngredientRecipePart)((Object)o)).getRecipePart();
        }
        if (o instanceof Ingredient) {
            return new RecipePartIngredient((Ingredient)o);
        }
        if (o instanceof IRecipePart) {
            return (IRecipePart)o;
        }
        if (o instanceof Item) {
            return new RecipePartNormal(new ItemStack((Item)o));
        }
        if (o instanceof Block) {
            return new RecipePartNormal(new ItemStack((Block)o));
        }
        if (o instanceof ItemStack) {
            return new RecipePartNormal((ItemStack)o);
        }
        if (o instanceof String) {
            return new RecipePartOredict((String)o);
        }
        if (o instanceof Class) {
            return new RecipePartClass((Class)o);
        }
        if (o instanceof Fluid) {
            return new RecipePartFluid((Fluid)o);
        }
        if (o instanceof FluidStack) {
            return new RecipePartFluid((FluidStack)o);
        }
        if (o instanceof Supplier) {
            return RecipeUtil.getRecipePart(((Supplier)o).get());
        }
        throw new IllegalArgumentException();
    }

    public static ISpecialOutput getSpecialOutput(JsonContext context, JsonObject json) {
        String className = JsonUtils.func_151219_a((JsonObject)json, (String)"specialOutput", null);
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> c = null;
            try {
                c = clazz.getConstructor(JsonContext.class, JsonElement.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (c != null) {
                return (ISpecialOutput)c.newInstance(context, json);
            }
            return (ISpecialOutput)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JsonSyntaxException("Illegal specialOutput was specified: The class " + className + "doesn't exist.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new JsonSyntaxException("Could not instantiate specialOutput: " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JsonSyntaxException("Could not instantiate specialOutput: " + className + ". There is no fitting public constructor in there.", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new JsonSyntaxException("Could not instantiate specialOutput: " + className + ". The class does not implement ISpecialOutput.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JsonSyntaxException("Could not instantiate specialOutput: " + className + ". The class could not be initialized.", (Throwable)e);
        }
    }

    public static void registerRecipeFactories() {
    }
}

