/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.block.te.element;

import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.block.te.element.TileEntityElementBase;
import aroma1997.core.misc.CachedCapabilityProvider;
import aroma1997.core.network.AutoEncode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyElement
extends TileEntityElementBase
implements IEnergyStorage {
    @AutoEncode
    private int energy;
    @AutoEncode
    private int maxStorage;
    private int acceptLimit;
    private int emitLimit;
    private final Set<EnumFacing> acceptingSides = EnumSet.allOf(EnumFacing.class);
    private final Set<EnumFacing> emittingSides = EnumSet.allOf(EnumFacing.class);
    private final CachedCapabilityProvider<IEnergyStorage> lookup = new CachedCapabilityProvider<IEnergyStorage>(x$0 -> new EnergyImpl((EnumFacing)x$0));

    public EnergyElement(TileEntityBase parent, int maxStorage, int acceptLimit, int emitLimit) {
        super(parent);
        this.maxStorage = maxStorage;
        this.acceptLimit = acceptLimit;
        this.emitLimit = emitLimit;
    }

    public EnergyElement(TileEntityBase parent, int maxStorage, int limit) {
        this(parent, maxStorage, limit, limit);
    }

    public EnergyElement(TileEntityBase parent, int maxStorage) {
        this(parent, maxStorage, Integer.MAX_VALUE);
    }

    public void setAcceptingSides(Collection<EnumFacing> sides) {
        this.acceptingSides.clear();
        this.acceptingSides.addAll(sides);
    }

    public void setEmittingSides(Collection<EnumFacing> sides) {
        this.emittingSides.clear();
        this.emittingSides.addAll(sides);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int ret = Math.max(Math.min(this.getMaxEnergyStored() - this.energy, maxReceive), 0);
        if (!simulate) {
            this.energy += ret;
        }
        return ret;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int ret = Math.max(Math.min(this.energy, maxExtract), 0);
        if (!simulate) {
            this.energy -= ret;
        }
        return ret;
    }

    public int getEnergyStored() {
        return Math.min(this.getMaxEnergyStored(), this.energy);
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        this.energy = nbt.func_74762_e("current");
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound nbt) {
        nbt = super.writeToNbt(nbt);
        nbt.func_74768_a("current", this.energy);
        return nbt;
    }

    @Override
    public Collection<? extends Capability<?>> getProvidedCapabilities(EnumFacing side) {
        return Collections.singleton(CapabilityEnergy.ENERGY);
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return (T)this.lookup.get(side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public Class<? extends TileEntityElementBase> getElementClass() {
        return EnergyElement.class;
    }

    private class EnergyImpl
    implements IEnergyStorage {
        private final EnumFacing side;

        public EnergyImpl(EnumFacing side) {
            this.side = side;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            return EnergyElement.this.receiveEnergy(Math.min(EnergyElement.this.acceptLimit, maxReceive), simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            return EnergyElement.this.extractEnergy(Math.min(EnergyElement.this.emitLimit, maxExtract), simulate);
        }

        public int getEnergyStored() {
            return EnergyElement.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return EnergyElement.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return EnergyElement.this.emittingSides.contains(this.side);
        }

        public boolean canReceive() {
            return EnergyElement.this.acceptingSides.contains(this.side);
        }
    }
}

