/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.transformer.universal;

import com.cleanroommc.fugue.common.Fugue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import top.outlands.foundation.IExplicitTransformer;

public class FinalStripperTransformer
implements IExplicitTransformer {
    private final Map<String, String> targets;

    public FinalStripperTransformer(Map<String, String> targets) {
        this.targets = targets;
    }

    public byte[] transform(byte[] bytes) {
        try {
            CtClass cc = ClassPool.getDefault().makeClass((InputStream)new ByteArrayInputStream(bytes));
            cc.defrost();
            String[] fields = this.targets.get(cc.getName()).split("\\|");
            Arrays.stream(cc.getFields()).filter(ctField -> Arrays.stream(fields).anyMatch(f -> ctField.getName().equals(f))).forEach(ctField2 -> {
                ctField2.setModifiers(ctField2.getModifiers() & 0xFFFFFFEF);
                Fugue.LOGGER.debug("Stripping final modifier of {} from {}", (Object)ctField2.getName(), (Object)ctField2.getDeclaringClass().getName());
            });
            cc.defrost();
            bytes = cc.toBytecode();
        }
        catch (Throwable t) {
            Fugue.LOGGER.error("Exception {} on {}", (Object)t, (Object)this.getClass().getSimpleName());
        }
        return bytes;
    }
}

