/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.imaginebreaker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jdk.internal.reflect.Reflection;
import sun.misc.Unsafe;

public final class ImagineBreaker {
    public static final boolean IS_OPEN_J9 = ImagineBreaker.isOpenJ9();
    private static final Unsafe UNSAFE = ImagineBreaker.retrieveUnsafe();
    private static final MethodHandles.Lookup LOOKUP = ImagineBreaker.retrieveLookup();
    private static final MethodHandle MODULE$ADD_EXPORTS_TO_ALL_0 = ImagineBreaker.retrieveAddExportsToAll0();
    private static final Set<Module> EVERYONE_MODULE_SET = ImagineBreaker.retrieveEveryoneSet();
    private static final VarHandle MODULE$OPEN_PACKAGES = ImagineBreaker.retrieveOpenPackagesHandle();
    private static final VarHandle CLASS$MODULE = ImagineBreaker.retrieveModuleHandle();
    private static final VarHandle REFLECTION$FIELD_FILTER_MAP = ImagineBreaker.retrieveFieldFilterMap();
    private static final VarHandle REFLECTION$METHOD_FILTER_MAP = ImagineBreaker.retrieveMethodFilterMap();
    private static final VarHandle CLASS$REFLECTION_DATA = ImagineBreaker.retrieveReflectionData();

    public static Unsafe unsafe() {
        return UNSAFE;
    }

    public static MethodHandles.Lookup lookup() {
        return LOOKUP;
    }

    public static void openBootModules() {
        ImagineBreaker.openModuleLayer(ModuleLayer.boot());
    }

    public static void openBootModule(String bootModule) {
        ImagineBreaker.openModule(ModuleLayer.boot().findModule(bootModule).orElseThrow());
    }

    public static void openModuleLayer(ModuleLayer layer) {
        layer.modules().forEach(ImagineBreaker::openModule);
    }

    public static void openModule(Module module) {
        MODULE$OPEN_PACKAGES.set(module, WorldRejector.INSTANCE);
        for (String pkg : module.getPackages()) {
            try {
                MODULE$ADD_EXPORTS_TO_ALL_0.invokeExact(module, pkg);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void disguiseAsModule(Class<?> target, Class<?> moduleClass) {
        Object module = CLASS$MODULE.get(moduleClass);
        CLASS$MODULE.set(target, module);
    }

    public static void disguiseAsModule(Class<?> target, Module module) {
        CLASS$MODULE.set(target, module);
    }

    public static void disguiseAsModule(Class<?> target, Class<?> moduleClass, Runnable runnable) {
        Object old = CLASS$MODULE.get(target);
        ImagineBreaker.disguiseAsModule(target, moduleClass);
        runnable.run();
        CLASS$MODULE.set(target, old);
    }

    public static void disguiseAsModule(Class<?> target, Module module, Runnable runnable) {
        Object old = CLASS$MODULE.get(target);
        ImagineBreaker.disguiseAsModule(target, module);
        runnable.run();
        CLASS$MODULE.set(target, old);
    }

    public static void wipeFieldFilters() {
        if (!IS_OPEN_J9) {
            for (Class clazz : REFLECTION$FIELD_FILTER_MAP.get().keySet()) {
                CLASS$REFLECTION_DATA.setVolatile(clazz, null);
            }
        }
        REFLECTION$FIELD_FILTER_MAP.setVolatile(new HashMap());
    }

    public static void wipeMethodFilters() {
        if (!IS_OPEN_J9) {
            for (Class clazz : REFLECTION$METHOD_FILTER_MAP.get().keySet()) {
                CLASS$REFLECTION_DATA.setVolatile(clazz, null);
            }
        }
        REFLECTION$METHOD_FILTER_MAP.setVolatile(new HashMap());
    }

    private static boolean isOpenJ9() {
        return "Eclipse OpenJ9".equals(System.getProperty("java.vm.vendor"));
    }

    private static Unsafe retrieveUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandles.Lookup retrieveLookup() {
        Field methodHandles$lookup$implLookup = ImagineBreaker.retrieveImplLookup();
        long offset = UNSAFE.staticFieldOffset(methodHandles$lookup$implLookup);
        return (MethodHandles.Lookup)UNSAFE.getObject(MethodHandles.Lookup.class, offset);
    }

    private static Field retrieveImplLookup() {
        try {
            return MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandle retrieveAddExportsToAll0() {
        try {
            return LOOKUP.findStatic(Module.class, "addExportsToAll0", MethodType.methodType(Void.TYPE, Module.class, String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<Module> retrieveEveryoneSet() {
        try {
            return LOOKUP.findStaticVarHandle(Module.class, "EVERYONE_SET", Set.class).get();
        }
        catch (IllegalAccessException e1) {
            if (e1.getMessage().endsWith("Expected static field.")) {
                try {
                    return ImagineBreaker.mockLookup(Module.class).findStaticVarHandle(Module.class, "EVERYONE_SET", Set.class).get();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e1);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static VarHandle retrieveOpenPackagesHandle() {
        try {
            return LOOKUP.findVarHandle(Module.class, "openPackages", Map.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static VarHandle retrieveModuleHandle() {
        try {
            return LOOKUP.findVarHandle(Class.class, "module", Module.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static VarHandle retrieveFieldFilterMap() {
        try {
            ImagineBreaker.openBootModule("java.base");
            return LOOKUP.findStaticVarHandle(Reflection.class, "fieldFilterMap", Map.class);
        }
        catch (IllegalAccessException e1) {
            if (e1.getMessage().endsWith("Expected static field.")) {
                try {
                    return ImagineBreaker.mockLookup(Reflection.class).findStaticVarHandle(Reflection.class, "fieldFilterMap", Map.class);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e1);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static VarHandle retrieveMethodFilterMap() {
        try {
            ImagineBreaker.openBootModule("java.base");
            return LOOKUP.findStaticVarHandle(Reflection.class, "methodFilterMap", Map.class);
        }
        catch (IllegalAccessException e1) {
            if (e1.getMessage().endsWith("Expected static field.")) {
                try {
                    return ImagineBreaker.mockLookup(Reflection.class).findStaticVarHandle(Reflection.class, "methodFilterMap", Map.class);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e1);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static VarHandle retrieveReflectionData() {
        try {
            return LOOKUP.findVarHandle(Class.class, "reflectionData", SoftReference.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            if (!IS_OPEN_J9) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    private static MethodHandles.Lookup mockLookup(Class<?> mockClass) throws Throwable {
        MethodHandle lookup$ctor = LOOKUP.findConstructor(MethodHandles.Lookup.class, MethodType.methodType(Void.TYPE, Class.class, Class.class, Integer.TYPE, Boolean.TYPE));
        return lookup$ctor.invokeExact(mockClass, null, 31, false);
    }

    private ImagineBreaker() {
    }

    private static class WorldRejector
    extends AbstractMap<String, Set<Module>> {
        private static final WorldRejector INSTANCE = new WorldRejector();

        private WorldRejector() {
        }

        @Override
        public Set<Module> get(Object key) {
            return EVERYONE_MODULE_SET;
        }

        @Override
        public Set<Map.Entry<String, Set<Module>>> entrySet() {
            return Collections.emptySet();
        }
    }
}

