/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation.trie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import top.outlands.foundation.trie.AbstractTrie;

public class TrieNode<V> {
    private static final String DEFAULT_CHARS_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+._$";
    public static final int CHAR_LENGTH = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+._$".length();
    private static char[] chars;
    protected static int[] CHAR_TO_INDEX_MAP;
    TrieNode<V>[] children = new TrieNode[chars.length];
    TrieNode<V> parent;
    boolean isKeyValueNode;
    V value = null;
    int level;
    String snippet;
    int numChildren;
    transient int[] childrenIndices;
    List<TrieNode<V>> KeyValueNodes;

    private static void setSupportedChars() {
        char c;
        chars = DEFAULT_CHARS_STRING.toCharArray();
        int n = -1;
        for (char c2 : chars) {
            if (c2 <= c) continue;
            c = c2;
        }
        int[] ciMap = new int[c + true];
        Arrays.fill(ciMap, -1);
        for (int i = 0; i < chars.length; ++i) {
            ciMap[TrieNode.chars[i]] = i;
        }
        CHAR_TO_INDEX_MAP = ciMap;
        AbstractTrie.CHAR_TO_INDEX_MAP = ciMap;
    }

    protected TrieNode(String snippet, int level) {
        this.level = level;
        this.snippet = snippet;
        this.childrenIndices = new int[chars.length];
        Arrays.fill(this.childrenIndices, -1);
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isKeyValueNode() {
        return this.isKeyValueNode;
    }

    public TrieNode<V> getParent() {
        return this.parent;
    }

    public String getKey() {
        StringBuilder keyChars = new StringBuilder();
        TrieNode<V> node = this;
        while (!node.isRoot()) {
            keyChars.insert(0, node.snippet);
            node = node.parent;
        }
        return new String(keyChars);
    }

    public int getNumChildren() {
        return this.numChildren;
    }

    public List<TrieNode<V>> getNonNullChildren() {
        ArrayList<TrieNode<V>> result = new ArrayList<TrieNode<V>>(this.numChildren);
        for (int i = 0; i < this.numChildren; ++i) {
            TrieNode<V> child = this.children[this.childrenIndices[i]];
            result.add(child);
        }
        return result;
    }

    public String toString() {
        return "SuffixTrieNode [isKeyValueNode=" + this.isKeyValueNode + ", value=" + String.valueOf(this.value) + ", level=" + this.level + ", key=" + this.getKey() + ", snippet=" + this.snippet + "]";
    }

    protected void addChild(TrieNode<V> child) {
        int index = CHAR_TO_INDEX_MAP[child.snippet.charAt(0)];
        this.children[index] = child;
        this.addChildIndex(index);
        child.parent = this;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public void addChildIndex(int index) {
        this.childrenIndices[this.numChildren++] = index;
    }

    public TrieNode<V> getFirstChild() {
        return this.numChildren == 0 ? null : this.children[this.childrenIndices[0]];
    }

    public boolean isRoot() {
        return this.level == 0;
    }

    public List<TrieNode<V>> getKeyValueNodes() {
        if (this.KeyValueNodes == null) {
            ArrayList<TrieNode<V>> lns = new ArrayList<TrieNode<V>>();
            if (this.isKeyValueNode) {
                lns.add(this);
            }
            for (int i = 0; i < this.numChildren; ++i) {
                TrieNode<V> child = this.children[this.childrenIndices[i]];
                lns.addAll(child.getKeyValueNodes());
            }
            this.KeyValueNodes = Collections.unmodifiableList(lns);
        }
        return this.KeyValueNodes;
    }

    public List<TrieNode<V>> getKeyValueNodes(Function<TrieNode<V>, Boolean> condition) {
        List<TrieNode<V>> kvNodes = this.getKeyValueNodes();
        ArrayList<TrieNode<V>> result = new ArrayList<TrieNode<V>>();
        for (TrieNode<V> kvNode : kvNodes) {
            if (!condition.apply(kvNode).booleanValue()) continue;
            result.add(kvNode);
        }
        return result;
    }

    public TrieNode<V> getBestKeyValueNode(Comparator<TrieNode<V>> comparator) {
        List<TrieNode<V>> KvNodes = this.getKeyValueNodes();
        return Collections.max(KvNodes, comparator);
    }

    public List<TrieNode<V>> getBestKeyValueNodes(int numTopKeyValueNodes, Comparator<TrieNode<V>> comparator) {
        if (numTopKeyValueNodes <= 0) {
            throw new IllegalArgumentException("IllegalArgumentException: numTopKeyValueNodes (" + numTopKeyValueNodes + ") should be positive ");
        }
        List<TrieNode<V>> kvNodes = this.getKeyValueNodes();
        if (numTopKeyValueNodes == 1) {
            TrieNode<V> kvNode = Collections.max(kvNodes, comparator);
            ArrayList<TrieNode<V>> result = new ArrayList<TrieNode<V>>();
            result.add(kvNode);
            return result;
        }
        ArrayList<TrieNode<V>> tempNodes = new ArrayList<TrieNode<V>>(kvNodes);
        Collections.sort(tempNodes, comparator.reversed());
        return tempNodes.subList(0, Math.min(numTopKeyValueNodes, kvNodes.size()));
    }

    static {
        TrieNode.setSupportedChars();
    }
}

