/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation.trie;

import java.util.Arrays;
import java.util.List;
import top.outlands.foundation.trie.AbstractTrie;
import top.outlands.foundation.trie.TrieNode;

public class PrefixTrie<V>
extends AbstractTrie<V> {
    public PrefixTrie() {
    }

    public PrefixTrie(List<String> keys, List<V> values) {
        super(keys, values);
    }

    public PrefixTrie(String[] keys, V[] values) {
        super(Arrays.asList(keys), Arrays.asList(values));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean put(String key, V value) {
        node = this.root;
        chars = key.toCharArray();
        indices = this.lookupIndices(chars);
        if (indices == null) {
            return false;
        }
        fed = 0;
        while (true) {
            for (i = 0; i < node.snippet.length(); ++i) {
                if (node.snippet.charAt(i) != chars[fed + i]) {
                    this.breakApart(node, i);
                    node.addChild(this.genValueNode(key.substring(fed + i), value, key.length()));
                    ++this.size;
                    return true;
                }
                if (fed + i == key.length() - 1) {
                    if (i < node.snippet.length() - 1) {
                        this.breakApart(node, i + 1);
                        ++this.size;
                    } else if (!node.isKeyValueNode) {
                        ++this.size;
                    }
                    node.isKeyValueNode = true;
                    node.value = value;
                    return true;
                }
                if (i != node.snippet.length() - 1) continue;
                temp = node.children[indices[fed + i + 1]];
                if (temp == null) {
                    node.addChild(this.genValueNode(key.substring(fed + i + 1), value, key.length()));
                    ++this.size;
                    return true;
                }
                fed += node.snippet.length();
                node = temp;
                break;
            }
            if (node != this.root) ** continue;
            temp = node.children[this.charToIndex(chars[0])];
            if (temp == null) {
                node.addChild(this.genValueNode(key, value, key.length()));
                ++this.size;
                return true;
            }
            node = temp;
        }
    }

    private void breakApart(TrieNode<V> node, int i) {
        TrieNode child = new TrieNode(node.snippet.substring(i), node.level);
        child.isKeyValueNode = node.isKeyValueNode;
        child.children = node.children;
        child.numChildren = node.numChildren;
        child.childrenIndices = node.childrenIndices;
        child.parent = node;
        child.value = node.value;
        for (TrieNode<V> c : node.getNonNullChildren()) {
            c.parent = child;
        }
        node.children = new TrieNode[TrieNode.CHAR_LENGTH];
        node.isKeyValueNode = false;
        node.value = null;
        node.level = node.parent.level + i;
        node.snippet = node.snippet.substring(0, i);
        int index = this.charToIndex(child.snippet.charAt(0));
        node.children[index] = child;
        node.childrenIndices = new int[TrieNode.CHAR_LENGTH];
        node.numChildren = 0;
        node.addChildIndex(index);
    }

    private TrieNode<V> genValueNode(String snippet, V value, int fullLength) {
        TrieNode node = new TrieNode(snippet, fullLength);
        node.isKeyValueNode = true;
        node.value = value;
        return node;
    }

    @Override
    protected TrieNode<V> getNodeWithLongestCommonPart(String key, int maxPrefixLength) {
        if (maxPrefixLength < 0) {
            throw new IllegalArgumentException("IllegalArgumentException: the argument 'maxPrefixLength' (" + maxPrefixLength + ") should be non-negative.");
        }
        if (maxPrefixLength > key.length()) {
            throw new IllegalArgumentException("IllegalArgumentException: the argument 'maxPrefixLength' (" + maxPrefixLength + ") should not be larger than word.length().");
        }
        TrieNode node = this.root;
        int i = 0;
        while (i < maxPrefixLength) {
            if (key.substring(i).startsWith(node.snippet)) {
                if ((i += node.snippet.length()) == key.length()) {
                    return node;
                }
            } else {
                return node;
            }
            int index = this.charToIndex(key.charAt(i));
            if (index >= 0 && node.children[index] != null) {
                node = node.children[index];
                continue;
            }
            return node;
        }
        return node;
    }

    public TrieNode<V> getFirstKeyValueNode(String key) {
        TrieNode node = this.root;
        int i = 0;
        while (i < key.length()) {
            if (key.substring(i).startsWith(node.snippet)) {
                if (node.isKeyValueNode) {
                    return node;
                }
                if ((i += node.snippet.length()) == key.length()) {
                    break;
                }
            } else {
                return null;
            }
            int index = this.charToIndex(key.charAt(i));
            if (index >= 0 && node.children[index] != null) {
                node = node.children[index];
                continue;
            }
            return null;
        }
        if (node.isKeyValueNode) {
            return node;
        }
        return null;
    }
}

