/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import net.minecraft.launchwrapper.Launch;
import top.outlands.foundation.IExplicitTransformer;
import top.outlands.foundation.boot.Foundation;

public class ASMClassWriterTransformer
implements IExplicitTransformer {
    @Override
    public byte[] transform(byte[] basicClass) {
        try {
            ClassPool cp = ClassPool.getDefault();
            CtClass cc = cp.makeClass((InputStream)new ByteArrayInputStream(basicClass));
            Foundation.LOGGER.debug("Patching " + cc.getName());
            CtMethod method = cc.getDeclaredMethod("getCommonSuperClass");
            method.setBody("{return top.outlands.foundation.transformer.ASMClassWriterTransformer.getCommonSuperClass($$);}");
            basicClass = cc.toBytecode();
        }
        catch (Throwable t) {
            Foundation.LOGGER.error((Object)t);
        }
        return basicClass;
    }

    public static String getCommonSuperClass(String type1, String type2) {
        Class<?> class2;
        Class<?> class1;
        ClassLoader classLoader = Launch.appClassLoader;
        try {
            class1 = Class.forName(type1.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            try {
                class1 = Class.forName(type1.replace('/', '.'), false, Launch.classLoader);
            }
            catch (ClassNotFoundException e1) {
                throw new TypeNotPresentException(type1, e1);
            }
        }
        try {
            class2 = Class.forName(type2.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            try {
                class2 = Class.forName(type2.replace('/', '.'), false, Launch.classLoader);
            }
            catch (ClassNotFoundException e2) {
                throw new TypeNotPresentException(type2, e2);
            }
        }
        if (class1.isAssignableFrom(class2)) {
            return type1;
        }
        if (class2.isAssignableFrom(class1)) {
            return type2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
        }
        return class1.getName().replace('.', '/');
    }
}

