/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation.boot;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.outlands.foundation.boot.EmptyLogger;
import zone.rong.imaginebreaker.ImagineBreaker;

public class Foundation {
    public static Logger LOGGER = System.getProperty("java.system.class.loader") == null ? LogManager.getLogger((String)"Foundation") : new EmptyLogger();
    private static final Set<String> OUTDATED_VISITOR = new HashSet<String>();

    public static void add(String name) {
        if (!OUTDATED_VISITOR.contains(name)) {
            LOGGER.warn("{} can't handle Java 21 class, please port the mod (if you are the author)!", (Object)name);
            OUTDATED_VISITOR.add(name);
        }
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> LOGGER.error((Object)thread, throwable));
        try {
            Foundation.breakModuleAndReflection();
            if (Launch.classLoader == null) {
                Launch.classLoader = new LaunchClassLoader(Foundation.class.getClassLoader());
                LOGGER.info("System ClassLoader is AppCL");
            } else {
                LOGGER = LogManager.getLogger((String)"Foundation");
                LOGGER.info("System ClassLoader is LCL");
            }
            Object handler = Class.forName("top.outlands.foundation.LaunchHandler", true, Launch.classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            Method launch = handler.getClass().getMethod("launch", String[].class);
            launch.invoke(handler, new Object[]{args});
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void breakModuleAndReflection() {
        ImagineBreaker.openBootModules();
        ImagineBreaker.wipeFieldFilters();
        ImagineBreaker.wipeMethodFilters();
    }
}

