/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation.boot;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Logger;
import top.outlands.foundation.boot.Foundation;
import top.outlands.foundation.boot.TransformerHolder;
import top.outlands.foundation.trie.PrefixTrie;
import top.outlands.foundation.trie.TrieNode;
import zone.rong.imaginebreaker.ImagineBreaker;

public class ActualClassLoader
extends URLClassLoader {
    public static final int BUFFER_SIZE = 4096;
    private final List<URL> sources;
    private final Set<String> jarNames = new HashSet<String>();
    private ClassLoader parent = ActualClassLoader.class.getClassLoader();
    public static final PrefixTrie<Boolean> classLoaderExceptions = new PrefixTrie();
    public static final PrefixTrie<Boolean> transformerExceptions = new PrefixTrie();
    private final Map<String, Class<?>> cachedClasses = new ConcurrentHashMap();
    private final Set<String> invalidClasses = new HashSet<String>(1024);
    private final Map<String, byte[]> resourceCache = new ConcurrentHashMap<String, byte[]>(1024);
    private final Set<String> negativeResourceCache = ConcurrentHashMap.newKeySet();
    private final ThreadLocal<byte[]> loadBuffer = new ThreadLocal();
    private static final String[] RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final boolean DUMP = Boolean.parseBoolean(System.getProperty("foundation.dump", "false"));
    private static final boolean VERBOSE = Boolean.parseBoolean(System.getProperty("foundation.verbose", "false"));
    private static File dumpSubDir;
    static TransformerHolder transformerHolder;
    private Map<Package, Manifest> packageManifests = null;
    private static Manifest EMPTY;
    private static final MethodHandles.Lookup LOOKUP;
    private static Consumer<URL> addURL;

    public ActualClassLoader(URL[] sources) {
        this(sources, null);
    }

    public ActualClassLoader(URL[] sources, ClassLoader loader) {
        super(sources, loader);
        if (loader != null) {
            this.parent = loader;
        }
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
        this.addClassLoaderExclusion0("java.");
        this.addClassLoaderExclusion0("javax.");
        this.addClassLoaderExclusion0("org.w3c.dom.");
        this.addClassLoaderExclusion0("org.xml.sax.");
        this.addClassLoaderExclusion0("jdk.");
        this.addClassLoaderExclusion0("sun.");
        this.addClassLoaderExclusion0("org.apache.logging.");
        this.addClassLoaderExclusion0("org.apache.commons.");
        this.addClassLoaderExclusion0("org.apache.http.");
        this.addClassLoaderExclusion0("org.apache.maven.");
        this.addClassLoaderExclusion0("org.openjdk.nashorn.");
        this.addClassLoaderExclusion0("org.omg.");
        this.addClassLoaderExclusion0("org.slf4j.");
        this.addClassLoaderExclusion0("org.burningwave.");
        this.addClassLoaderExclusion0("org.ietf.jgss.");
        this.addClassLoaderExclusion0("org.jcp.xml.dsig.internal.");
        this.addClassLoaderExclusion0("netscape.javascript.");
        this.addClassLoaderExclusion0("com.sun.");
        this.addClassLoaderExclusion0("net.minecraft.launchwrapper.LaunchClassLoader");
        this.addClassLoaderExclusion0("net.minecraft.launchwrapper.Launch");
        this.addClassLoaderExclusion0("top.outlands.foundation.boot.");
        this.addClassLoaderExclusion0("top.outlands.foundation.function.");
        this.addClassLoaderExclusion0("top.outlands.foundation.trie.");
        this.addClassLoaderExclusion0("io.github.toolfactory.");
        this.addClassLoaderExclusion0("org.burningwave.");
        this.addClassLoaderExclusion0("javassist.");
        this.addClassLoaderExclusion0("com.jcraft.");
        this.addClassLoaderExclusion0("com.google.gson.");
        this.addClassLoaderExclusion0("com.google.common.");
        this.addClassLoaderExclusion0("com.google.thirdparty.publicsuffix.");
        this.addClassLoaderExclusion0("io.netty.");
        this.addClassLoaderExclusion0("pro.gravit.launcher.");
        this.addClassLoaderExclusion0("pro.gravit.utils.");
        this.addTransformerExclusion("org.spongepowered.asm.launch.");
        this.addTransformerExclusion("org.spongepowered.asm.logging.");
        this.addTransformerExclusion("org.spongepowered.asm.mixin.");
        this.addTransformerExclusion("org.spongepowered.asm.obfuscation.");
        this.addTransformerExclusion("org.spongepowered.asm.service.");
        this.addTransformerExclusion("org.spongepowered.asm.transformers.");
        this.addTransformerExclusion("org.spongepowered.asm.util.");
        this.addTransformerExclusion("org.spongepowered.include.com.google.");
        this.addTransformerExclusion("org.spongepowered.tools.");
        this.addTransformerExclusion("com.llamalad7.mixinextras.");
        if (DUMP) {
            File dumpDir = new File(Launch.minecraftHome, "CLASS_DUMP");
            if (!dumpDir.exists()) {
                dumpDir.mkdirs();
            }
            int i = 0;
            while ((dumpSubDir = new File(dumpDir, String.valueOf(++i))).exists()) {
            }
            dumpSubDir.mkdirs();
        }
    }

    public TransformerHolder getTransformerHolder() {
        return transformerHolder;
    }

    public void registerTransformer(String transformerClassName) {
        Foundation.LOGGER.debug("Registering transformer: " + transformerClassName);
        ActualClassLoader.transformerHolder.registerTransformerFunction.accept(transformerClassName);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.invalidClasses.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        TrieNode<Boolean> node = classLoaderExceptions.getFirstKeyValueNode(name);
        if (node != null && node.getValue().booleanValue()) {
            return this.parent.loadClass(name);
        }
        if (this.cachedClasses.containsKey(name)) {
            return this.cachedClasses.get(name);
        }
        try {
            Class<?> clazz;
            CodeSource codeSource;
            String transformedName = this.transformName(name);
            if (this.cachedClasses.containsKey(transformedName)) {
                return this.cachedClasses.get(transformedName);
            }
            String untransformedName = this.untransformName(name);
            int lastDot = untransformedName.lastIndexOf(46);
            String packageName = lastDot == -1 ? "" : untransformedName.substring(0, lastDot);
            String fileName = untransformedName.replace('.', '/').concat(".class");
            URLConnection urlConnection = this.findCodeSourceConnectionFor(fileName);
            CodeSigner[] signers = null;
            if (lastDot > -1 && !untransformedName.startsWith("net.minecraft.")) {
                if (urlConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                    JarFile jarFile = jarURLConnection.getJarFile();
                    if (jarFile != null && jarFile.getManifest() != null) {
                        Manifest manifest = jarFile.getManifest();
                        JarEntry entry = jarFile.getJarEntry(fileName);
                        Package pkg = this.getDefinedPackage(packageName);
                        this.getClassBytes(untransformedName);
                        signers = entry.getCodeSigners();
                        if (pkg == null) {
                            this.definePackage(packageName, manifest, jarURLConnection.getJarFileURL());
                        } else if (pkg.isSealed() && !pkg.isSealed(jarURLConnection.getJarFileURL())) {
                            Foundation.LOGGER.warn("The jar file {} is trying to seal already secured path {}", (Object)jarFile.getName(), (Object)packageName);
                        } else if (this.isSealed(packageName, manifest)) {
                            Foundation.LOGGER.warn("The jar file {} has a security seal for path {}, but that path is defined and not secure", (Object)jarFile.getName(), (Object)packageName);
                        }
                    }
                } else {
                    Package pkg = this.getPackage(packageName);
                    if (pkg == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else if (pkg.isSealed() && urlConnection != null) {
                        Foundation.LOGGER.warn("The URL {} is defining elements for sealed path {}", (Object)urlConnection.getURL(), (Object)packageName);
                    }
                }
            }
            if ((node = transformerExceptions.getFirstKeyValueNode(name)) != null && node.getValue().booleanValue()) {
                try {
                    byte[] transformedClass = this.getClassBytes(name);
                    transformedClass = this.runExplicitTransformers(transformedName, transformedClass);
                    CodeSource codeSource2 = codeSource = urlConnection == null ? null : new CodeSource(urlConnection.getURL(), signers);
                    if (transformedClass == null) {
                        throw new ClassNotFoundException(transformedName);
                    }
                    clazz = super.defineClass(name, transformedClass, 0, transformedClass.length, codeSource);
                    this.cachedClasses.put(name, clazz);
                    if (DUMP) {
                        this.saveClassBytes(transformedClass, transformedName);
                    }
                    return clazz;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            byte[] transformedClass = this.runExplicitTransformers(transformedName, this.runTransformers(untransformedName, transformedName, this.getClassBytes(untransformedName)));
            if (DUMP) {
                this.saveClassBytes(transformedClass, transformedName);
            }
            CodeSource codeSource3 = codeSource = urlConnection == null ? null : new CodeSource(urlConnection.getURL(), signers);
            if (transformedClass == null) {
                throw new ClassNotFoundException();
            }
            clazz = this.defineClass(transformedName, transformedClass, 0, transformedClass.length, codeSource);
            this.cachedClasses.put(transformedName, clazz);
            return clazz;
        }
        catch (Throwable e) {
            this.invalidClasses.add(name);
            if (VERBOSE) {
                Foundation.LOGGER.debug("Failed to load class {}, caused by {}", (Object)name, (Object)e);
                Arrays.stream(e.getStackTrace()).forEach(arg_0 -> ((Logger)Foundation.LOGGER).debug(arg_0));
            }
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    public void saveClassBytes(byte[] data, String transformedName) {
        if (data == null) {
            return;
        }
        File outFile = new File(dumpSubDir, transformedName.replace('.', File.separatorChar) + ".class");
        File outDir = outFile.getParentFile();
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            FileOutputStream output = new FileOutputStream(outFile);
            ((OutputStream)output).write(data);
            ((OutputStream)output).close();
        }
        catch (IOException ex) {
            Foundation.LOGGER.warn("Could not save transformed class \"%s\"", (Object)transformedName, (Object)ex);
        }
    }

    public String untransformName(String name) {
        name = ActualClassLoader.transformerHolder.unTransformNameFunction.apply(name);
        return name;
    }

    public String transformName(String name) {
        name = ActualClassLoader.transformerHolder.transformNameFunction.apply(name);
        return name;
    }

    protected boolean isSealed(String path, Manifest manifest) {
        Attributes attributes = manifest.getAttributes(path);
        String sealed = null;
        if (attributes != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attributes = manifest.getMainAttributes()) != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected URLConnection findCodeSourceConnectionFor(String name) {
        URL resource = this.findResource(name);
        if (resource != null) {
            try {
                return resource.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected byte[] runTransformers(String name, String transformedName, byte[] basicClass) {
        basicClass = ActualClassLoader.transformerHolder.runTransformersFunction.apply(name, transformedName, basicClass);
        return basicClass;
    }

    protected byte[] runExplicitTransformers(String transformedName, byte[] basicClass) {
        basicClass = ActualClassLoader.transformerHolder.runExplicitTransformersFunction.apply(transformedName, basicClass);
        return basicClass;
    }

    @Override
    public void addURL(URL url) {
        if (url != null) {
            for (URL u : this.sources) {
                if (!url.sameFile(u)) continue;
                return;
            }
            super.addURL(url);
            this.sources.add(url);
            addURL.accept(url);
        }
    }

    public List<URL> getSources() {
        return this.sources;
    }

    protected byte[] readFully(InputStream stream) {
        try {
            int read;
            byte[] buffer = this.getOrCreateBuffer();
            int totalLength = 0;
            while ((read = stream.read(buffer, totalLength, buffer.length - totalLength)) != -1) {
                if ((totalLength += read) < buffer.length - 1) continue;
                byte[] newBuffer = new byte[buffer.length + 4096];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                buffer = newBuffer;
            }
            byte[] result = new byte[totalLength];
            System.arraycopy(buffer, 0, result, 0, totalLength);
            return result;
        }
        catch (Throwable t) {
            Foundation.LOGGER.warn("Problem loading class", t);
            return new byte[0];
        }
    }

    protected byte[] getOrCreateBuffer() {
        byte[] buffer = this.loadBuffer.get();
        if (buffer == null) {
            this.loadBuffer.set(new byte[4096]);
            buffer = this.loadBuffer.get();
        }
        return buffer;
    }

    private void addClassLoaderExclusion0(String toExclude) {
        Foundation.LOGGER.debug("Adding classloader exclusion " + toExclude);
        classLoaderExceptions.put(toExclude, true);
    }

    public void addClassLoaderExclusion(String toExclude) {
        this.addTransformerExclusion(toExclude);
    }

    public void addTransformerExclusion(String toExclude) {
        Foundation.LOGGER.debug("Adding transformer exclusion " + toExclude);
        transformerExceptions.put(toExclude, true);
    }

    public void removeTransformerExclusion(String toExclude) {
        Foundation.LOGGER.debug("Removing transformer exclusion " + toExclude);
        TrieNode node = transformerExceptions.getKeyValueNode(toExclude);
        if (node != null) {
            node.setValue(false);
        } else {
            transformerExceptions.put(toExclude, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String name) throws IOException {
        URL classResource;
        InputStream classStream;
        block7: {
            String reservedName2;
            if (this.negativeResourceCache.contains(name)) {
                return null;
            }
            if (this.resourceCache.containsKey(name)) {
                return this.resourceCache.get(name);
            }
            if (name.indexOf(46) == -1) {
                for (String reservedName2 : RESERVED_NAMES) {
                    byte[] data;
                    if (!name.toUpperCase(Locale.ENGLISH).startsWith(reservedName2) || (data = this.getClassBytes("_" + name)) == null) continue;
                    this.resourceCache.put(name, data);
                    return data;
                }
            }
            classStream = null;
            try {
                String resourcePath = name.replace('.', '/').concat(".class");
                classResource = this.findResource(resourcePath);
                if (classResource != null) break block7;
                this.negativeResourceCache.add(name);
                reservedName2 = null;
            }
            catch (Throwable throwable) {
                ActualClassLoader.closeSilently(classStream);
                throw throwable;
            }
            ActualClassLoader.closeSilently(classStream);
            return reservedName2;
        }
        classStream = classResource.openStream();
        byte[] data = this.readFully(classStream);
        this.resourceCache.put(name, data);
        byte[] byArray = data;
        ActualClassLoader.closeSilently(classStream);
        return byArray;
    }

    public void printDebugMessage() {
        ActualClassLoader.transformerHolder.debugPrinter.run();
    }

    public Map<String, Class<?>> getCachedClasses() {
        return this.cachedClasses;
    }

    public Set<String> getInvalidClasses() {
        return this.invalidClasses;
    }

    public Class<?> defineClass(String name, byte[] buffer) {
        Class<?> clazz = this.defineClass(name, buffer, 0, buffer.length);
        this.cachedClasses.put(name, clazz);
        return clazz;
    }

    public Class<?> defineClass(String name, byte[] buffer, CodeSource codeSource) {
        Class<?> clazz = this.defineClass(name, buffer, 0, buffer.length, codeSource);
        this.cachedClasses.put(name, clazz);
        return clazz;
    }

    public boolean isClassLoaded(String name) {
        return this.findLoadedClass(name) != null;
    }

    public boolean isClassExist(String name) {
        try {
            return this.getClassBytes(name) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void clearNegativeEntries(Set<String> entriesToClear) {
        this.negativeResourceCache.removeAll(entriesToClear);
    }

    public List<String> getTransformerExclusions() {
        return transformerExceptions.getRoot().getKeyValueNodes().stream().map(TrieNode::getKey).toList();
    }

    static {
        transformerHolder = new TransformerHolder();
        EMPTY = new Manifest();
        LOOKUP = ImagineBreaker.lookup();
        addURL = e -> {};
    }
}

