/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.opengl;

import java.nio.ByteBuffer;
import org.lwjgl3.opengl.GL;
import org.lwjgl3.system.Checks;
import org.lwjgl3.system.JNI;
import org.lwjgl3.system.MemoryStack;
import org.lwjgl3.system.MemoryUtil;
import org.lwjgl3.system.NativeType;

public class GLXARBGetProcAddress {
    protected GLXARBGetProcAddress() {
        throw new UnsupportedOperationException();
    }

    public static long nglXGetProcAddressARB(long procName) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetProcAddressARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPP((long)procName, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long glXGetProcAddressARB(@NativeType(value="GLchar const *") ByteBuffer procName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)procName);
        }
        return GLXARBGetProcAddress.nglXGetProcAddressARB(MemoryUtil.memAddress((ByteBuffer)procName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long glXGetProcAddressARB(@NativeType(value="GLchar const *") CharSequence procName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(procName, true);
            long procNameEncoded = stack.getPointerAddress();
            long l = GLXARBGetProcAddress.nglXGetProcAddressARB(procNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

