/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl3.opengl.GL;
import org.lwjgl3.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl3.system.Checks;
import org.lwjgl3.system.JNI;
import org.lwjgl3.system.MemoryStack;
import org.lwjgl3.system.MemoryUtil;
import org.lwjgl3.system.NativeType;
import org.lwjgl3.system.Pointer;

public class AMDDebugOutput {
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_AMD = 37189;
    public static final int GL_DEBUG_SEVERITY_HIGH_AMD = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_AMD = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_AMD = 37192;
    public static final int GL_DEBUG_CATEGORY_API_ERROR_AMD = 37193;
    public static final int GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 37194;
    public static final int GL_DEBUG_CATEGORY_DEPRECATION_AMD = 37195;
    public static final int GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 37196;
    public static final int GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 37197;
    public static final int GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 37198;
    public static final int GL_DEBUG_CATEGORY_APPLICATION_AMD = 37199;
    public static final int GL_DEBUG_CATEGORY_OTHER_AMD = 37200;

    protected AMDDebugOutput() {
        throw new UnsupportedOperationException();
    }

    public static native void nglDebugMessageEnableAMD(int var0, int var1, int var2, long var3, boolean var5);

    public static void glDebugMessageEnableAMD(@NativeType(value="GLenum") int category, @NativeType(value="GLenum") int severity, @Nullable @NativeType(value="GLuint const *") IntBuffer ids, @NativeType(value="GLboolean") boolean enabled) {
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, Checks.remainingSafe((Buffer)ids), MemoryUtil.memAddressSafe((IntBuffer)ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageEnableAMD(@NativeType(value="GLenum") int category, @NativeType(value="GLenum") int severity, @NativeType(value="GLuint const *") int id, @NativeType(value="GLboolean") boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, 1, MemoryUtil.memAddress((IntBuffer)ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageInsertAMD(int var0, int var1, int var2, int var3, long var4);

    public static void glDebugMessageInsertAMD(@NativeType(value="GLenum") int category, @NativeType(value="GLenum") int severity, @NativeType(value="GLuint") int id, @NativeType(value="GLchar const *") ByteBuffer buf) {
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, buf.remaining(), MemoryUtil.memAddress((ByteBuffer)buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsertAMD(@NativeType(value="GLenum") int category, @NativeType(value="GLenum") int severity, @NativeType(value="GLuint") int id, @NativeType(value="GLchar const *") CharSequence buf) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int bufEncodedLength = stack.nUTF8(buf, false);
            long bufEncoded = stack.getPointerAddress();
            AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, bufEncodedLength, bufEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageCallbackAMD(long var0, long var2);

    public static void glDebugMessageCallbackAMD(@Nullable @NativeType(value="GLDEBUGPROCAMD") GLDebugMessageAMDCallbackI callback, @NativeType(value="void *") long userParam) {
        AMDDebugOutput.nglDebugMessageCallbackAMD(MemoryUtil.memAddressSafe((Pointer)callback), userParam);
    }

    public static native int nglGetDebugMessageLogAMD(int var0, int var1, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="GLuint")
    public static int glGetDebugMessageLogAMD(@NativeType(value="GLuint") int count, @Nullable @NativeType(value="GLenum *") IntBuffer categories, @Nullable @NativeType(value="GLenum *") IntBuffer severities, @Nullable @NativeType(value="GLuint *") IntBuffer ids, @Nullable @NativeType(value="GLsizei *") IntBuffer lengths, @Nullable @NativeType(value="GLchar *") ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)categories, (int)count);
            Checks.checkSafe((Buffer)severities, (int)count);
            Checks.checkSafe((Buffer)ids, (int)count);
            Checks.checkSafe((Buffer)lengths, (int)count);
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, Checks.remainingSafe((Buffer)messageLog), MemoryUtil.memAddressSafe((IntBuffer)categories), MemoryUtil.memAddressSafe((IntBuffer)severities), MemoryUtil.memAddressSafe((IntBuffer)ids), MemoryUtil.memAddressSafe((IntBuffer)lengths), MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static void glDebugMessageEnableAMD(@NativeType(value="GLenum") int category, @NativeType(value="GLenum") int severity, @Nullable @NativeType(value="GLuint const *") int[] ids, @NativeType(value="GLboolean") boolean enabled) {
        long __functionAddress = GL.getICD().glDebugMessageEnableAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((int)category, (int)severity, (int)Checks.lengthSafe((int[])ids), (int[])ids, (boolean)enabled, (long)__functionAddress);
    }

    @NativeType(value="GLuint")
    public static int glGetDebugMessageLogAMD(@NativeType(value="GLuint") int count, @Nullable @NativeType(value="GLenum *") int[] categories, @Nullable @NativeType(value="GLenum *") int[] severities, @Nullable @NativeType(value="GLuint *") int[] ids, @Nullable @NativeType(value="GLsizei *") int[] lengths, @Nullable @NativeType(value="GLchar *") ByteBuffer messageLog) {
        long __functionAddress = GL.getICD().glGetDebugMessageLogAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])categories, (int)count);
            Checks.checkSafe((int[])severities, (int)count);
            Checks.checkSafe((int[])ids, (int)count);
            Checks.checkSafe((int[])lengths, (int)count);
        }
        return JNI.callPPPPPI((int)count, (int)Checks.remainingSafe((Buffer)messageLog), (int[])categories, (int[])severities, (int[])ids, (int[])lengths, (long)MemoryUtil.memAddressSafe((ByteBuffer)messageLog), (long)__functionAddress);
    }

    static {
        GL.initialize();
    }
}

