/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.glfw;

import javax.annotation.Nullable;
import org.lwjgl3.glfw.GLFW;
import org.lwjgl3.glfw.GLFWScrollCallbackI;
import org.lwjgl3.system.Callback;

public abstract class GLFWScrollCallback
extends Callback
implements GLFWScrollCallbackI {
    public static GLFWScrollCallback create(long functionPointer) {
        GLFWScrollCallbackI instance = (GLFWScrollCallbackI)Callback.get((long)functionPointer);
        return instance instanceof GLFWScrollCallback ? (GLFWScrollCallback)instance : new Container(functionPointer, instance);
    }

    @Nullable
    public static GLFWScrollCallback createSafe(long functionPointer) {
        return functionPointer == 0L ? null : GLFWScrollCallback.create(functionPointer);
    }

    public static GLFWScrollCallback create(GLFWScrollCallbackI instance) {
        return instance instanceof GLFWScrollCallback ? (GLFWScrollCallback)instance : new Container(instance.address(), instance);
    }

    protected GLFWScrollCallback() {
        super(CIF);
    }

    GLFWScrollCallback(long functionPointer) {
        super(functionPointer);
    }

    public GLFWScrollCallback set(long window) {
        GLFW.glfwSetScrollCallback(window, this);
        return this;
    }

    private static final class Container
    extends GLFWScrollCallback {
        private final GLFWScrollCallbackI delegate;

        Container(long functionPointer, GLFWScrollCallbackI delegate) {
            super(functionPointer);
            this.delegate = delegate;
        }

        @Override
        public void invoke(long window, double xoffset, double yoffset) {
            this.delegate.invoke(window, xoffset, yoffset);
        }
    }
}

