/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.glfw;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl3.BufferUtils;
import org.lwjgl3.glfw.GLFWAllocateCallback;
import org.lwjgl3.glfw.GLFWAllocateCallbackI;
import org.lwjgl3.glfw.GLFWDeallocateCallback;
import org.lwjgl3.glfw.GLFWDeallocateCallbackI;
import org.lwjgl3.glfw.GLFWReallocateCallback;
import org.lwjgl3.glfw.GLFWReallocateCallbackI;
import org.lwjgl3.system.Checks;
import org.lwjgl3.system.MemoryStack;
import org.lwjgl3.system.MemoryUtil;
import org.lwjgl3.system.NativeResource;
import org.lwjgl3.system.NativeType;
import org.lwjgl3.system.Struct;
import org.lwjgl3.system.StructBuffer;

@NativeType(value="struct GLFWallocator")
public class GLFWAllocator
extends Struct<GLFWAllocator>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATE;
    public static final int REALLOCATE;
    public static final int DEALLOCATE;
    public static final int USER;

    protected GLFWAllocator(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected GLFWAllocator create(long address, @Nullable ByteBuffer container) {
        return new GLFWAllocator(address, container);
    }

    public GLFWAllocator(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), GLFWAllocator.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="GLFWallocatefun")
    public GLFWAllocateCallback allocate() {
        return GLFWAllocator.nallocate(this.address());
    }

    @NativeType(value="GLFWreallocatefun")
    public GLFWReallocateCallback reallocate() {
        return GLFWAllocator.nreallocate(this.address());
    }

    @NativeType(value="GLFWdeallocatefun")
    public GLFWDeallocateCallback deallocate() {
        return GLFWAllocator.ndeallocate(this.address());
    }

    @NativeType(value="void *")
    public long user() {
        return GLFWAllocator.nuser(this.address());
    }

    public GLFWAllocator allocate(@NativeType(value="GLFWallocatefun") GLFWAllocateCallbackI value) {
        GLFWAllocator.nallocate(this.address(), value);
        return this;
    }

    public GLFWAllocator reallocate(@NativeType(value="GLFWreallocatefun") GLFWReallocateCallbackI value) {
        GLFWAllocator.nreallocate(this.address(), value);
        return this;
    }

    public GLFWAllocator deallocate(@NativeType(value="GLFWdeallocatefun") GLFWDeallocateCallbackI value) {
        GLFWAllocator.ndeallocate(this.address(), value);
        return this;
    }

    public GLFWAllocator user(@NativeType(value="void *") long value) {
        GLFWAllocator.nuser(this.address(), value);
        return this;
    }

    public GLFWAllocator set(GLFWAllocateCallbackI allocate, GLFWReallocateCallbackI reallocate, GLFWDeallocateCallbackI deallocate, long user) {
        this.allocate(allocate);
        this.reallocate(reallocate);
        this.deallocate(deallocate);
        this.user(user);
        return this;
    }

    public GLFWAllocator set(GLFWAllocator src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static GLFWAllocator malloc() {
        return new GLFWAllocator(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static GLFWAllocator calloc() {
        return new GLFWAllocator(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static GLFWAllocator create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new GLFWAllocator(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static GLFWAllocator create(long address) {
        return new GLFWAllocator(address, null);
    }

    @Nullable
    public static GLFWAllocator createSafe(long address) {
        return address == 0L ? null : new GLFWAllocator(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)GLFWAllocator.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = GLFWAllocator.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static GLFWAllocator malloc(MemoryStack stack) {
        return new GLFWAllocator(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static GLFWAllocator calloc(MemoryStack stack) {
        return new GLFWAllocator(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static GLFWAllocateCallback nallocate(long struct) {
        return GLFWAllocateCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)ALLOCATE)));
    }

    public static GLFWReallocateCallback nreallocate(long struct) {
        return GLFWReallocateCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)REALLOCATE)));
    }

    public static GLFWDeallocateCallback ndeallocate(long struct) {
        return GLFWDeallocateCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)DEALLOCATE)));
    }

    public static long nuser(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USER));
    }

    public static void nallocate(long struct, GLFWAllocateCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ALLOCATE), (long)value.address());
    }

    public static void nreallocate(long struct, GLFWReallocateCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REALLOCATE), (long)value.address());
    }

    public static void ndeallocate(long struct, GLFWDeallocateCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEALLOCATE), (long)value.address());
    }

    public static void nuser(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USER), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ALLOCATE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)REALLOCATE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DEALLOCATE)));
    }

    static {
        Struct.Layout layout = GLFWAllocator.__struct((Struct.Member[])new Struct.Member[]{GLFWAllocator.__member((int)POINTER_SIZE), GLFWAllocator.__member((int)POINTER_SIZE), GLFWAllocator.__member((int)POINTER_SIZE), GLFWAllocator.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCATE = layout.offsetof(0);
        REALLOCATE = layout.offsetof(1);
        DEALLOCATE = layout.offsetof(2);
        USER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<GLFWAllocator, Buffer>
    implements NativeResource {
        private static final GLFWAllocator ELEMENT_FACTORY = GLFWAllocator.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected GLFWAllocator getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="GLFWallocatefun")
        public GLFWAllocateCallback allocate() {
            return GLFWAllocator.nallocate(this.address());
        }

        @NativeType(value="GLFWreallocatefun")
        public GLFWReallocateCallback reallocate() {
            return GLFWAllocator.nreallocate(this.address());
        }

        @NativeType(value="GLFWdeallocatefun")
        public GLFWDeallocateCallback deallocate() {
            return GLFWAllocator.ndeallocate(this.address());
        }

        @NativeType(value="void *")
        public long user() {
            return GLFWAllocator.nuser(this.address());
        }

        public Buffer allocate(@NativeType(value="GLFWallocatefun") GLFWAllocateCallbackI value) {
            GLFWAllocator.nallocate(this.address(), value);
            return this;
        }

        public Buffer reallocate(@NativeType(value="GLFWreallocatefun") GLFWReallocateCallbackI value) {
            GLFWAllocator.nreallocate(this.address(), value);
            return this;
        }

        public Buffer deallocate(@NativeType(value="GLFWdeallocatefun") GLFWDeallocateCallbackI value) {
            GLFWAllocator.ndeallocate(this.address(), value);
            return this;
        }

        public Buffer user(@NativeType(value="void *") long value) {
            GLFWAllocator.nuser(this.address(), value);
            return this;
        }
    }
}

