/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.asm;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MixinVerifier
extends SimpleVerifier {
    private Type currentClass;
    private Type currentSuperClass;
    private List<Type> currentClassInterfaces;
    private boolean isInterface;

    public MixinVerifier(int api, Type currentClass, Type currentSuperClass, List<Type> currentClassInterfaces, boolean isInterface) {
        super(api, currentClass, currentSuperClass, currentClassInterfaces, isInterface);
        this.currentClass = currentClass;
        this.currentSuperClass = currentSuperClass;
        this.currentClassInterfaces = currentClassInterfaces;
        this.isInterface = isInterface;
    }

    protected boolean isInterface(Type type) {
        if (type.equals((Object)this.currentClass)) {
            return this.isInterface;
        }
        ClassInfo classInfo = ClassInfo.forType(type, ClassInfo.TypeLookup.ELEMENT_TYPE);
        if (classInfo == null) {
            return false;
        }
        return classInfo.isInterface();
    }

    protected Type getSuperClass(Type type) {
        if (type.equals((Object)this.currentClass)) {
            return this.currentSuperClass;
        }
        ClassInfo classInfo = ClassInfo.forType(type, ClassInfo.TypeLookup.ELEMENT_TYPE);
        if (classInfo == null) {
            return null;
        }
        ClassInfo c = classInfo.getSuperClass();
        return c == null ? null : Type.getType((String)("L" + c.getName() + ";"));
    }

    protected boolean isAssignableFrom(Type type, Type other) {
        ClassInfo otherInfo;
        if (type.equals((Object)other)) {
            return true;
        }
        if (type.equals((Object)this.currentClass)) {
            if (this.getSuperClass(other) == null) {
                return false;
            }
            if (this.isInterface) {
                return other.getSort() == 10 || other.getSort() == 9;
            }
            return this.isAssignableFrom(type, this.getSuperClass(other));
        }
        if (other.equals((Object)this.currentClass)) {
            if (this.isAssignableFrom(type, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (Type v : this.currentClassInterfaces) {
                    if (!this.isAssignableFrom(type, v)) continue;
                    return true;
                }
            }
            return false;
        }
        if (type.getDescriptor().endsWith("Ljava/lang/Object;")) {
            return true;
        }
        ClassInfo typeInfo = ClassInfo.forType(type, ClassInfo.TypeLookup.ELEMENT_TYPE);
        if (typeInfo == null) {
            return false;
        }
        if (typeInfo.isInterface()) {
            typeInfo = ClassInfo.forName("java/lang/Object");
        }
        if ((otherInfo = ClassInfo.forType(other, ClassInfo.TypeLookup.ELEMENT_TYPE)) == null) {
            return false;
        }
        return otherInfo.hasSuperClass(typeInfo);
    }
}

