/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service.mojang;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.service.IClassTracker;
import top.outlands.foundation.boot.ActualClassLoader;
import top.outlands.foundation.trie.PrefixTrie;

final class LaunchClassLoaderUtil
implements IClassTracker {
    private final LaunchClassLoader classLoader;
    private final Map<String, Class<?>> cachedClasses;
    private final Set<String> invalidClasses;
    private final PrefixTrie<Boolean> classLoaderExceptions;
    private final PrefixTrie<Boolean> transformerExceptions;

    LaunchClassLoaderUtil(LaunchClassLoader classLoader) {
        this.classLoader = classLoader;
        this.cachedClasses = Launch.classLoader.getCachedClasses();
        this.invalidClasses = Launch.classLoader.getInvalidClasses();
        this.classLoaderExceptions = ActualClassLoader.classLoaderExceptions;
        this.transformerExceptions = ActualClassLoader.transformerExceptions;
    }

    @Override
    public boolean isClassLoaded(String name) {
        return this.cachedClasses.containsKey(name);
    }

    @Override
    public String getClassRestrictions(String className) {
        Object restrictions = "";
        if (this.isClassClassLoaderExcluded(className, null)) {
            restrictions = "PACKAGE_CLASSLOADER_EXCLUSION";
        }
        if (this.isClassTransformerExcluded(className, null)) {
            restrictions = (String)(!((String)restrictions).isEmpty() ? (String)restrictions + "," : "") + "PACKAGE_TRANSFORMER_EXCLUSION";
        }
        return restrictions;
    }

    boolean isClassExcluded(String name, String transformedName) {
        return this.isClassClassLoaderExcluded(name, transformedName) || this.isClassTransformerExcluded(name, transformedName);
    }

    boolean isClassClassLoaderExcluded(String name, String transformedName) {
        PrefixTrie<Boolean> trie = this.getClassLoaderExceptions();
        if (transformedName != null) {
            return trie.getFirstKeyValueNode(name) != null || trie.getFirstKeyValueNode(transformedName) != null;
        }
        return trie.getFirstKeyValueNode(name) != null;
    }

    boolean isClassTransformerExcluded(String name, String transformedName) {
        PrefixTrie<Boolean> trie = this.getTransformerExceptions();
        if (transformedName != null) {
            return trie.getFirstKeyValueNode(name) != null || trie.getFirstKeyValueNode(transformedName) != null;
        }
        return trie.getFirstKeyValueNode(name) != null;
    }

    @Override
    public void registerInvalidClass(String name) {
        if (this.invalidClasses != null) {
            this.invalidClasses.add(name);
        }
    }

    PrefixTrie<Boolean> getClassLoaderExceptions() {
        return Objects.requireNonNullElseGet(this.classLoaderExceptions, PrefixTrie::new);
    }

    PrefixTrie<Boolean> getTransformerExceptions() {
        return Objects.requireNonNullElseGet(this.transformerExceptions, PrefixTrie::new);
    }
}

