/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ObjectHolderRef;

public enum ObjectHolderRegistry {
    INSTANCE;

    private List<ObjectHolderRef> objectHolders = Lists.newArrayList();

    public void findObjectHolders(ASMDataTable table) {
        boolean isClass;
        String value;
        String annotationTarget;
        String className;
        FMLLog.log.info("Processing ObjectHolder annotations");
        Set<ASMDataTable.ASMData> allObjectHolders = table.getAll(GameRegistry.ObjectHolder.class.getName());
        HashMap classModIds = Maps.newHashMap();
        HashMap classCache = Maps.newHashMap();
        for (ASMDataTable.ASMData data : table.getAll(Mod.class.getName())) {
            String modid = (String)data.getAnnotationInfo().get("modid");
            classModIds.put(data.getClassName(), modid);
        }
        for (ASMDataTable.ASMData data : allObjectHolders) {
            className = data.getClassName();
            annotationTarget = data.getObjectName();
            value = (String)data.getAnnotationInfo().get("value");
            isClass = className.equals(annotationTarget);
            if (!isClass) continue;
            this.scanTarget(classModIds, classCache, className, annotationTarget, value, isClass, false);
        }
        for (ASMDataTable.ASMData data : allObjectHolders) {
            className = data.getClassName();
            annotationTarget = data.getObjectName();
            value = (String)data.getAnnotationInfo().get("value");
            isClass = className.equals(annotationTarget);
            if (isClass) continue;
            this.scanTarget(classModIds, classCache, className, annotationTarget, value, isClass, false);
        }
        this.scanTarget(classModIds, classCache, "net.minecraft.init.Blocks", null, "minecraft", true, true);
        this.scanTarget(classModIds, classCache, "net.minecraft.init.Items", null, "minecraft", true, true);
        this.scanTarget(classModIds, classCache, "net.minecraft.init.MobEffects", null, "minecraft", true, true);
        this.scanTarget(classModIds, classCache, "net.minecraft.init.Biomes", null, "minecraft", true, true);
        this.scanTarget(classModIds, classCache, "net.minecraft.init.Enchantments", null, "minecraft", true, true);
        this.scanTarget(classModIds, classCache, "net.minecraft.init.SoundEvents", null, "minecraft", true, true);
        this.scanTarget(classModIds, classCache, "net.minecraft.init.PotionTypes", null, "minecraft", true, true);
        FMLLog.log.info("Found {} ObjectHolder annotations", (Object)this.objectHolders.size());
    }

    private void scanTarget(Map<String, String> classModIds, Map<String, Class<?>> classCache, String className, @Nullable String annotationTarget, String value, boolean isClass, boolean extractFromValue) {
        Class<?> clazz;
        if (classCache.containsKey(className)) {
            clazz = classCache.get(className);
        } else {
            try {
                clazz = Class.forName(className, extractFromValue, ((Object)((Object)this)).getClass().getClassLoader());
                classCache.put(className, clazz);
            }
            catch (ClassNotFoundException ex2) {
                throw new RuntimeException(ex2);
            }
        }
        if (isClass) {
            this.scanClassForFields(classModIds, className, (String)value, clazz, extractFromValue);
        } else {
            if (((String)value).indexOf(58) == -1) {
                String prefix = classModIds.get(className);
                if (prefix == null) {
                    FMLLog.log.warn("Found an unqualified ObjectHolder annotation ({}) without a modid context at {}.{}, ignoring", value, (Object)className, (Object)annotationTarget);
                    throw new IllegalStateException("Unqualified reference to ObjectHolder");
                }
                value = prefix + ":" + (String)value;
            }
            try {
                Field f2 = clazz.getDeclaredField(annotationTarget);
                this.addHolderReference(new ObjectHolderRef(f2, new nf((String)value), extractFromValue));
            }
            catch (NoSuchFieldException ex3) {
                throw new RuntimeException(ex3);
            }
        }
    }

    private void scanClassForFields(Map<String, String> classModIds, String className, String value, Class<?> clazz, boolean extractFromExistingValues) {
        classModIds.put(className, value);
        for (Field f2 : clazz.getFields()) {
            boolean isMatch;
            int mods = f2.getModifiers();
            boolean bl2 = isMatch = Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods);
            if (!isMatch || f2.isAnnotationPresent(GameRegistry.ObjectHolder.class)) continue;
            this.addHolderReference(new ObjectHolderRef(f2, new nf(value, f2.getName()), extractFromExistingValues));
        }
    }

    private void addHolderReference(ObjectHolderRef ref) {
        if (ref.isValid()) {
            this.objectHolders.add(ref);
        }
    }

    public void applyObjectHolders() {
        FMLLog.log.info("Applying holder lookups");
        for (ObjectHolderRef ohr : this.objectHolders) {
            ohr.apply();
        }
        FMLLog.log.info("Holder lookups applied");
    }
}

