/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixins;
import zone.rong.mixinbooter.IEarlyMixinLoader;

@IFMLLoadingPlugin.Name(value="MixinBooter")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=1)
public final class MixinBooterPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinBooter");

    @Override
    public String[] getASMTransformerClass() {
        return null;
    }

    @Override
    public String getModContainerClass() {
        return "net.minecraftforge.fml.common.MixinContainer";
    }

    @Override
    public String getSetupClass() {
        return "net.minecraftforge.fml.relauncher.MixinSetup";
    }

    @Override
    public void injectData(Map<String, Object> data) {
        Object coremodList = data.get("coremodList");
        if (coremodList instanceof List) {
            Field fmlPluginWrapper$coreModInstance = null;
            for (Object coremod : (List)coremodList) {
                try {
                    Object theMod;
                    if (fmlPluginWrapper$coreModInstance == null) {
                        fmlPluginWrapper$coreModInstance = coremod.getClass().getField("coreModInstance");
                        fmlPluginWrapper$coreModInstance.setAccessible(true);
                    }
                    if (!((theMod = fmlPluginWrapper$coreModInstance.get(coremod)) instanceof IEarlyMixinLoader)) continue;
                    IEarlyMixinLoader loader = (IEarlyMixinLoader)theMod;
                    LOGGER.info("Grabbing {} for its mixins.", loader.getClass());
                    for (String mixinConfig : loader.getMixinConfigs()) {
                        if (!loader.shouldMixinConfigQueue(mixinConfig)) continue;
                        LOGGER.info("Adding {} mixin configuration.", (Object)mixinConfig);
                        Mixins.addConfiguration((String)mixinConfig);
                        loader.onMixinConfigQueued(mixinConfig);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Unexpected error", t);
                }
            }
        }
    }

    @Override
    public String getAccessTransformerClass() {
        return null;
    }
}

