/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ITypeDiscoverer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.apache.commons.io.IOUtils;

public class DirectoryDiscoverer
implements ITypeDiscoverer {
    private ASMDataTable table;

    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        this.table = table;
        ArrayList found = Lists.newArrayList();
        FMLLog.log.debug("Examining directory {} for potential mods", (Object)candidate.getModContainer().getName());
        this.exploreFileSystem("", candidate.getModContainer(), found, candidate, null);
        for (ModContainer mc : found) {
            table.addContainer(mc);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exploreFileSystem(String path, File modDir, List<ModContainer> harvestedMods, ModCandidate candidate, @Nullable MetadataCollection mc) {
        if (path.length() == 0) {
            File metadata = new File(modDir, "mcmod.info");
            try {
                FileInputStream fis = new FileInputStream(metadata);
                try {
                    mc = MetadataCollection.from(fis, modDir.getName());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                FMLLog.log.debug("Found an mcmod.info file in directory {}", (Object)modDir.getName());
            }
            catch (Exception e) {
                mc = MetadataCollection.from(null, "");
                FMLLog.log.debug("No mcmod.info file found in directory {}", (Object)modDir.getName());
            }
        }
        Object[] content = modDir.listFiles(new ClassFilter(this));
        Arrays.sort(content);
        Object[] objectArray = content;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isDirectory()) {
                FMLLog.log.trace("Recursing into package {}", (Object)(path + ((File)file).getName()));
                this.exploreFileSystem(path + ((File)file).getName() + "/", (File)file, harvestedMods, candidate, mc);
            } else {
                Matcher match = classFile.matcher(((File)file).getName());
                if (match.matches()) {
                    ASMModParser modParser = null;
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream((File)file);
                        modParser = new ASMModParser(fis);
                        candidate.addClassEntry(path + ((File)file).getName());
                    }
                    catch (LoaderException e) {
                        try {
                            FMLLog.log.error("There was a problem reading the file {} - probably this is a corrupt file", (Object)((File)file).getPath(), (Object)e);
                            throw e;
                            catch (IOException e2) {
                                throw new RuntimeException(e2);
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fis);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                    modParser.validate();
                    modParser.sendToTable(this.table, candidate);
                    ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
                    if (container != null) {
                        harvestedMods.add(container);
                        container.bindMetadata(mc);
                    }
                }
            }
            ++n2;
        }
        return;
    }

    private class ClassFilter
    implements FileFilter {
        private ClassFilter(DirectoryDiscoverer directoryDiscoverer) {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && ITypeDiscoverer.classFile.matcher(file.getName()).matches() || file.isDirectory();
        }
    }
}

