/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm;

import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.common.patcher.ClassPatchManager;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.commons.Remapper;
import org.spongepowered.asm.bridge.RemapperAdapterFML;
import org.spongepowered.asm.launch.platform.MixinPlatformAgentFMLLegacy;
import org.spongepowered.asm.mixin.extensibility.IRemapper;

public class FMLSanityChecker
implements IFMLCallHook {
    private static final String FMLFINGERPRINT = "51:0A:FB:4C:AF:A4:A0:F2:F5:CF:C5:0E:B4:CC:3C:30:24:4A:E3:8E".toLowerCase().replace(":", "");
    private static final String FORGEFINGERPRINT = "E3:C3:D5:0C:7C:98:6D:F7:4C:64:5C:0A:C5:46:39:74:1C:90:A5:57".toLowerCase().replace(":", "");
    private static final String MCFINGERPRINT = "CD:99:95:96:56:F7:53:DC:28:D8:63:B4:67:69:F7:F8:FB:AE:FC:FC".toLowerCase().replace(":", "");
    private LaunchClassLoader cl;
    private boolean liveEnv;
    public static File fmlLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        int certCount;
        boolean goodMC;
        boolean goodFML;
        CodeSource codeSource;
        block23: {
            block24: {
                JarFile mcJarFile;
                block22: {
                    codeSource = this.getClass().getProtectionDomain().getCodeSource();
                    goodFML = false;
                    boolean fmlIsJar = false;
                    if (codeSource.getLocation().getProtocol().equals("jar")) {
                        fmlIsJar = true;
                        Certificate[] certificates = codeSource.getCertificates();
                        if (certificates != null) {
                            for (Certificate cert : certificates) {
                                String fingerprint = CertificateHelper.getFingerprint(cert);
                                if (fingerprint.equals(FMLFINGERPRINT)) {
                                    FMLLog.log.info("Found valid fingerprint for FML. Certificate fingerprint {}", (Object)fingerprint);
                                    goodFML = true;
                                    continue;
                                }
                                if (fingerprint.equals(FORGEFINGERPRINT)) {
                                    FMLLog.log.info("Found valid fingerprint for Minecraft Forge. Certificate fingerprint {}", (Object)fingerprint);
                                    goodFML = true;
                                    continue;
                                }
                                FMLLog.log.error("Found invalid fingerprint for FML: {}", (Object)fingerprint);
                            }
                        }
                    } else {
                        goodFML = true;
                    }
                    goodMC = FMLLaunchHandler.side() == Side.SERVER || !this.liveEnv;
                    certCount = 0;
                    try {
                        Class<?> cbr = Class.forName("net.minecraft.client.ClientBrandRetriever", false, (ClassLoader)this.cl);
                        codeSource = cbr.getProtectionDomain().getCodeSource();
                    }
                    catch (Exception e) {
                        goodMC = true;
                    }
                    mcJarFile = null;
                    if (!fmlIsJar || goodMC || !codeSource.getLocation().getProtocol().equals("jar")) break block24;
                    try {
                        String mcPath = codeSource.getLocation().getPath().substring(5);
                        mcPath = mcPath.substring(0, mcPath.lastIndexOf(33));
                        mcPath = URLDecoder.decode(mcPath, StandardCharsets.UTF_8.name());
                        mcJarFile = new JarFile(mcPath, true);
                        mcJarFile.getManifest();
                        JarEntry cbrEntry = mcJarFile.getJarEntry("net/minecraft/client/ClientBrandRetriever.class");
                        InputStream mcJarFileInputStream = mcJarFile.getInputStream(cbrEntry);
                        try {
                            ByteStreams.toByteArray((InputStream)mcJarFileInputStream);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)mcJarFileInputStream);
                        }
                        Certificate[] certificates = cbrEntry.getCertificates();
                        int n = certCount = certificates != null ? certificates.length : 0;
                        if (certificates == null) break block22;
                        for (Certificate cert : certificates) {
                            String fingerprint = CertificateHelper.getFingerprint(cert);
                            if (!fingerprint.equals(MCFINGERPRINT)) continue;
                            FMLLog.log.info("Found valid fingerprint for Minecraft. Certificate fingerprint {}", (Object)fingerprint);
                            goodMC = true;
                        }
                    }
                    catch (Throwable e) {
                        try {
                            FMLLog.log.error("A critical error occurred trying to read the minecraft jar file", e);
                            break block23;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            IOUtils.closeQuietly(mcJarFile);
                        }
                    }
                }
                IOUtils.closeQuietly((Closeable)mcJarFile);
                break block23;
            }
            goodMC = true;
        }
        if (!goodMC) {
            FMLLog.log.error("The minecraft jar {} appears to be corrupt! There has been CRITICAL TAMPERING WITH MINECRAFT, it is highly unlikely minecraft will work! STOP NOW, get a clean copy and try again!", (Object)codeSource.getLocation().getFile());
            if (!Boolean.parseBoolean(System.getProperty("fml.ignoreInvalidMinecraftCertificates", "false"))) {
                FMLLog.log.error("For your safety, FML will not launch minecraft. You will need to fetch a clean version of the minecraft jar file");
                FMLLog.log.error("Technical information: The class net.minecraft.client.ClientBrandRetriever should have been associated with the minecraft jar file, and should have returned us a valid, intact minecraft jar location. This did not work. Either you have modified the minecraft jar file (if so run the forge installer again), or you are using a base editing jar that is changing this class (and likely others too). If you REALLY want to run minecraft in this configuration, add the flag -Dfml.ignoreInvalidMinecraftCertificates=true to the 'JVM settings' in your launcher profile.");
                FMLCommonHandler.instance().exitJava(1, false);
            } else {
                FMLLog.log.error("FML has been ordered to ignore the invalid or missing minecraft certificate. This is very likely to cause a problem!");
                FMLLog.log.error("Technical information: ClientBrandRetriever was at {}, there were {} certificates for it", (Object)codeSource.getLocation(), (Object)certCount);
            }
        }
        if (!goodFML) {
            FMLLog.log.error("FML appears to be missing any signature data. This is not a good thing");
        }
        return null;
    }

    @Override
    public void injectData(Map<String, Object> data) {
        this.liveEnv = (Boolean)data.get("runtimeDeobfuscationEnabled");
        this.cl = (LaunchClassLoader)data.get("classLoader");
        File mcDir = (File)data.get("mcLocation");
        fmlLocation = (File)data.get("coremodLocation");
        ClassPatchManager.INSTANCE.setup(FMLLaunchHandler.side());
        FMLDeobfuscatingRemapper.INSTANCE.setup(mcDir, this.cl, (String)data.get("deobfuscationFileName"), this.liveEnv);
        MixinPlatformAgentFMLLegacy.injectRemapper((IRemapper)RemapperAdapterFML.create((Remapper)FMLDeobfuscatingRemapper.INSTANCE, FMLDeobfuscatingRemapper.INSTANCE::unmap));
    }
}

