/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import it.zerono.mods.zerocore.internal.ZeroCore;
import it.zerono.mods.zerocore.lib.network.ModMessageHandler;
import it.zerono.mods.zerocore.lib.network.ModTileEntityMessage;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class ModTileEntityMessageHandler<MessageT extends ModTileEntityMessage>
extends ModMessageHandler<MessageT> {
    @Override
    protected void processMessage(MessageT message, MessageContext ctx) {
        World world = this.getWorld(ctx);
        BlockPos position = ((ModTileEntityMessage)message).getPos();
        if (null == world) {
            ZeroCore.getLogger().error("Invalid world instance found while processing a ModTileEntityMessage: skipping message");
            return;
        }
        if (null == position) {
            ZeroCore.getLogger().error("Invalid tile entity position in a ModTileEntityMessage: skipping message");
            return;
        }
        TileEntity tileEntity = WorldHelper.getTile((IBlockAccess)world, position);
        if (null != tileEntity) {
            this.processTileEntityMessage(message, ctx, tileEntity);
            return;
        }
        ZeroCore.getLogger().error("Invalid tile entity found at %d, %d, %d while processing a ModTileEntityMessage: skipping message", (Object)position.func_177958_n(), (Object)position.func_177956_o(), (Object)position.func_177952_p());
    }

    protected abstract World getWorld(MessageContext var1);

    protected abstract void processTileEntityMessage(MessageT var1, MessageContext var2, TileEntity var3);
}

