/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Arguments {
    private static final Pattern FLAG_REGEX = Pattern.compile("^--(.+)$");
    private final List<String> rawArgs;
    private final SetMultimap<String, String> parsedArgs;

    public Arguments(List<String> rawArgs) {
        this.rawArgs = rawArgs;
        this.parsedArgs = HashMultimap.create();
        String flag = null;
        ArrayList<String> value = null;
        for (int i = 0; i < this.rawArgs.size(); ++i) {
            String arg = this.rawArgs.get(i);
            Matcher matcher = FLAG_REGEX.matcher(arg);
            boolean matches = matcher.matches();
            if (flag == null || matches) {
                if (!matches) {
                    throw new ParseException("Expected flag at position " + i + " but got '" + arg + "' instead!");
                }
                if (flag != null) {
                    this.parsedArgs.put((Object)flag, (Object)String.join((CharSequence)" ", (Iterable<? extends CharSequence>)value));
                }
                flag = matcher.group(1).toLowerCase();
                value = new ArrayList<String>();
                continue;
            }
            value.add(arg);
        }
        if (flag != null) {
            this.parsedArgs.put(flag, (Object)String.join((CharSequence)" ", value));
        }
    }

    public List<String> raw() {
        return this.rawArgs;
    }

    public int intFlag(String key) {
        Iterator it = this.parsedArgs.get((Object)key).iterator();
        if (it.hasNext()) {
            try {
                return Math.abs(Integer.parseInt((String)it.next()));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid input for '" + key + "' argument. Please specify a number!");
            }
        }
        return -1;
    }

    public double doubleFlag(String key) {
        Iterator it = this.parsedArgs.get((Object)key).iterator();
        if (it.hasNext()) {
            try {
                return Math.abs(Double.parseDouble((String)it.next()));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid input for '" + key + "' argument. Please specify a number!");
            }
        }
        return -1.0;
    }

    public Set<String> stringFlag(String key) {
        return this.parsedArgs.get((Object)key);
    }

    public boolean boolFlag(String key) {
        return this.parsedArgs.containsKey((Object)key);
    }

    public static final class ParseException
    extends IllegalArgumentException {
        public ParseException(String s) {
            super(s);
        }
    }
}

