/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.server.command;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.command.ArgumentExecutor;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.main.EnumDailyRewardsStatusMessage;
import austeretony.oxygen_dailyrewards.common.network.client.CPOpenDailyRewardsMenu;
import austeretony.oxygen_dailyrewards.common.network.client.CPSyncPlayerData;
import austeretony.oxygen_dailyrewards.server.DailyRewardsManagerServer;
import austeretony.oxygen_dailyrewards.server.RewardsPlayerDataServer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class DailyRewardsArgumentOperator
implements ArgumentExecutor {
    public String getName() {
        return "dailyrewards";
    }

    public void process(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 2) {
            EntityPlayerMP senderPlayerMP = null;
            if (sender instanceof EntityPlayerMP) {
                senderPlayerMP = CommandBase.func_71521_c((ICommandSender)sender);
            }
            if (args.length == 2) {
                if (args[1].equals("-reload-rewards")) {
                    DailyRewardsManagerServer.instance().getRewardsDataContainer().reloadRewards();
                    OxygenHelperServer.sendStatusMessage((EntityPlayerMP)senderPlayerMP, (int)14, (int)EnumDailyRewardsStatusMessage.DAILY_REWARDS_RELOADED.ordinal(), (String[])new String[0]);
                    if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
                        OxygenMain.LOGGER.info("[Daily Rewards] (Operator/Console) {} reloaded daily rewards.", (Object)sender.func_70005_c_());
                    }
                }
            } else if (args.length == 3) {
                if (args[1].equals("-open-menu")) {
                    if (args.length == 3) {
                        EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                        OxygenMain.network().sendTo((Packet)new CPOpenDailyRewardsMenu(), targetPlayerMP);
                    }
                } else if (args[1].equals("-reset-latest-reward")) {
                    EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                    RewardsPlayerDataServer playerData = DailyRewardsManagerServer.instance().getPlayerDataContainer().getPlayerData(CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                    if (playerData != null) {
                        playerData.setDaysRewarded(playerData.getDaysRewarded() - 1);
                        playerData.setRewardedDaysSeries(playerData.getRewardedDaysSeries() - 1);
                        playerData.setLastRewardTimeMillis(0L);
                        playerData.setChanged(true);
                        OxygenMain.network().sendTo((Packet)new CPSyncPlayerData(playerData.getDaysRewarded(), playerData.getLastRewardTimeMillis()), targetPlayerMP);
                        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)senderPlayerMP, (int)14, (int)EnumDailyRewardsStatusMessage.PLAYER_LATEST_REWARD_RESET.ordinal(), (String[])new String[0]);
                        if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
                            OxygenMain.LOGGER.info("[Daily Rewards] (Operator/Console) {} reset player {}/{} latest daily reward.", (Object)sender.func_70005_c_(), (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                        }
                    }
                }
            } else if (args.length == 4 && args[1].equals("-set-days-rewarded")) {
                EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                int amount = CommandBase.func_175764_a((String)args[3], (int)0, (int)Short.MAX_VALUE);
                RewardsPlayerDataServer playerData = DailyRewardsManagerServer.instance().getPlayerDataContainer().getPlayerData(CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                if (playerData != null) {
                    playerData.setDaysRewarded(amount);
                    playerData.setRewardedDaysSeries(amount);
                    playerData.setLastRewardTimeMillis(0L);
                    playerData.setChanged(true);
                    OxygenMain.network().sendTo((Packet)new CPSyncPlayerData(amount, 0L), targetPlayerMP);
                    OxygenHelperServer.sendStatusMessage((EntityPlayerMP)senderPlayerMP, (int)14, (int)EnumDailyRewardsStatusMessage.PLAYER_REWARDS_AMOUNT_SET.ordinal(), (String[])new String[0]);
                    if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
                        OxygenMain.LOGGER.info("[Daily Rewards] (Operator/Console) {} set player {}/{} claimed rewards amount to <{}>.", (Object)sender.func_70005_c_(), (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP), (Object)amount);
                    }
                }
            }
        }
    }

    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-open-menu", "-reload-rewards", "-reset-latest-reward", "-set-days-rewarded"});
        }
        return Collections.emptyList();
    }
}

