/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.server;

import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.main.EnumDailyRewardsPrivilege;
import austeretony.oxygen_dailyrewards.server.DailyRewardsManagerServer;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.UUID;

public class RewardsPlayerDataServer
extends AbstractPersistentData {
    private int rewardedDaysSeries;
    private int daysRewarded;
    private long lastRewardTimeMillis;
    public final String dataPath;

    public RewardsPlayerDataServer(String dataPath) {
        this.dataPath = dataPath;
    }

    public boolean isRewardAvailable(UUID playerUUID) {
        boolean resetRewards;
        ZonedDateTime currentTime = TimeHelperServer.getZonedDateTime();
        ZonedDateTime lastTimePlayerRewarded = TimeHelperServer.getZonedDateTime((long)this.lastRewardTimeMillis);
        ZonedDateTime nextRewardTime = lastTimePlayerRewarded.plusDays(1L).withHour(DailyRewardsConfig.REWARD_TIME_OFFSET_HOURS.asInt()).withMinute(0).withSecond(0);
        if (Period.between(lastTimePlayerRewarded.toLocalDate(), currentTime.toLocalDate()).getDays() >= 2) {
            this.rewardedDaysSeries = 0;
        }
        boolean bl = DailyRewardsConfig.REWARD_MODE.asInt() == 0 ? lastTimePlayerRewarded.getMonthValue() != currentTime.getMonthValue() : (resetRewards = this.daysRewarded >= DailyRewardsManagerServer.instance().getRewardsDataContainer().getRewards().size());
        if (this.lastRewardTimeMillis != 0L && resetRewards && currentTime.getHour() >= DailyRewardsConfig.REWARD_TIME_OFFSET_HOURS.asInt()) {
            this.daysRewarded = 0;
        }
        int maximumRewards = PrivilegesProviderServer.getAsInt((UUID)playerUUID, (int)EnumDailyRewardsPrivilege.MAXIMUM_REWARDS_AMOUNT_PER_MONTH.id(), (int)DailyRewardsConfig.MAXIMUM_REWARDS_PER_MONTH.asInt());
        if (!PrivilegesProviderServer.getAsBoolean((UUID)playerUUID, (int)EnumDailyRewardsPrivilege.DAILY_REWARDS_ACCESS.id(), (boolean)DailyRewardsConfig.DAILY_REWARDS_ACCESS.asBoolean()) || this.daysRewarded >= maximumRewards) {
            return false;
        }
        return currentTime.compareTo(nextRewardTime) > 0;
    }

    public void rewarded() {
        ++this.rewardedDaysSeries;
        ++this.daysRewarded;
        this.lastRewardTimeMillis = TimeHelperServer.getCurrentMillis();
    }

    public int getRewardedDaysSeries() {
        return this.rewardedDaysSeries;
    }

    public void setRewardedDaysSeries(int value) {
        this.rewardedDaysSeries = value;
    }

    public int getDaysRewarded() {
        return this.daysRewarded;
    }

    public void setDaysRewarded(int value) {
        this.daysRewarded = value;
    }

    public long getLastRewardTimeMillis() {
        return this.lastRewardTimeMillis;
    }

    public void setLastRewardTimeMillis(long millis) {
        this.lastRewardTimeMillis = millis;
    }

    public String getDisplayName() {
        return "dailyrewards:player_data_server";
    }

    public String getPath() {
        return this.dataPath;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((short)((short)this.rewardedDaysSeries), (OutputStream)bos);
        StreamUtils.write((byte)1, (OutputStream)bos);
        StreamUtils.write((byte)0, (OutputStream)bos);
        StreamUtils.write((byte)((byte)this.daysRewarded), (OutputStream)bos);
        StreamUtils.write((long)this.lastRewardTimeMillis, (OutputStream)bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.rewardedDaysSeries = StreamUtils.readShort((InputStream)bis);
        int dummy = StreamUtils.readByte((InputStream)bis);
        dummy = StreamUtils.readByte((InputStream)bis);
        this.daysRewarded = StreamUtils.readByte((InputStream)bis);
        this.lastRewardTimeMillis = StreamUtils.readLong((InputStream)bis);
    }

    public void write(ByteBuf buffer) {
        buffer.writeShort(this.rewardedDaysSeries);
        buffer.writeByte(this.daysRewarded);
        buffer.writeLong(this.lastRewardTimeMillis);
    }

    public void reset() {
        this.rewardedDaysSeries = 0;
        this.daysRewarded = 0;
        this.lastRewardTimeMillis = 0L;
    }
}

