/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.server;

import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_dailyrewards.server.DailyRewardsManagerServer;
import austeretony.oxygen_dailyrewards.server.RewardsPlayerDataServer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class RewardsPlayerDataContainerServer {
    private final DailyRewardsManagerServer manager;
    private final Map<UUID, RewardsPlayerDataServer> players = new ConcurrentHashMap<UUID, RewardsPlayerDataServer>();

    protected RewardsPlayerDataContainerServer(DailyRewardsManagerServer manager) {
        this.manager = manager;
    }

    public RewardsPlayerDataServer createPlayerData(UUID playerUUID) {
        RewardsPlayerDataServer playerData = new RewardsPlayerDataServer(OxygenHelperServer.getDataFolder() + "/server/players/" + playerUUID + "/daily rewards/player_data.dat");
        OxygenHelperServer.loadPersistentData((PersistentData)playerData);
        this.players.put(playerUUID, playerData);
        return playerData;
    }

    @Nullable
    public RewardsPlayerDataServer getPlayerData(UUID playerUUID) {
        return this.players.get(playerUUID);
    }

    void save() {
        for (RewardsPlayerDataServer playerData : this.players.values()) {
            if (!playerData.isChanged()) continue;
            playerData.setChanged(false);
            OxygenHelperServer.savePersistentDataAsync((PersistentData)playerData);
        }
    }
}

