/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.main.EnumDailyRewardsStatusMessage;
import austeretony.oxygen_dailyrewards.common.network.client.CPSyncPlayerData;
import austeretony.oxygen_dailyrewards.common.reward.Reward;
import austeretony.oxygen_dailyrewards.server.DailyRewardsManagerServer;
import austeretony.oxygen_dailyrewards.server.RewardsPlayerDataServer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayersDataManagerServer {
    private final DailyRewardsManagerServer manager;

    public PlayersDataManagerServer(DailyRewardsManagerServer manager) {
        this.manager = manager;
    }

    public void playerLoaded(EntityPlayerMP playerMP) {
        Runnable task = () -> {
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
            RewardsPlayerDataServer playerData = this.manager.getPlayerDataContainer().getPlayerData(playerUUID);
            if (playerData == null) {
                playerData = this.manager.getPlayerDataContainer().createPlayerData(playerUUID);
                OxygenMain.network().sendTo((Packet)new CPSyncPlayerData(playerData.getDaysRewarded(), playerData.getLastRewardTimeMillis()), playerMP);
                if (playerData.isRewardAvailable(playerUUID)) {
                    OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)14, (int)EnumDailyRewardsStatusMessage.DAILY_REWARD_AVAILABLE.ordinal(), (String[])new String[0]);
                }
            }
        };
        OxygenHelperServer.addRoutineTask((Runnable)task);
    }

    public void claimReward(EntityPlayerMP playerMP) {
        RewardsPlayerDataServer playerData = this.manager.getPlayerDataContainer().getPlayerData(CommonReference.getPersistentUUID((Entity)playerMP));
        if (playerData != null) {
            if (playerData.isRewardAvailable(CommonReference.getPersistentUUID((Entity)playerMP))) {
                Reward reward = this.manager.getRewardsDataContainer().getDailyReward(playerData.getDaysRewarded() + 1);
                if (reward != null) {
                    if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
                        OxygenMain.LOGGER.info("[Daily Rewards] <{}/{}> [1]: trying reward player for day {}...", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)(playerData.getDaysRewarded() + 1));
                    }
                    if (reward.rewardPlayer(playerMP)) {
                        playerData.rewarded();
                        playerData.setChanged(true);
                        OxygenMain.network().sendTo((Packet)new CPSyncPlayerData(playerData.getDaysRewarded(), playerData.getLastRewardTimeMillis()), playerMP);
                        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)14, (int)EnumDailyRewardsStatusMessage.DAILY_REWARD_CLAIMED.ordinal(), (String[])new String[0]);
                        return;
                    }
                    if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
                        OxygenMain.LOGGER.info("[Daily Rewards] <{}/{}> failed to reward player for day {}.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)(playerData.getDaysRewarded() + 1));
                    }
                }
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)14, (int)EnumDailyRewardsStatusMessage.DAILY_REWARD_UNAVAILABLE.ordinal(), (String[])new String[0]);
            }
        }
    }
}

