/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.server;

import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.server.PlayersDataManagerServer;
import austeretony.oxygen_dailyrewards.server.RewardsDataContainerServer;
import austeretony.oxygen_dailyrewards.server.RewardsPlayerDataContainerServer;
import java.time.Duration;
import java.time.Month;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayerMP;

public class DailyRewardsManagerServer {
    private static DailyRewardsManagerServer instance;
    private final RewardsDataContainerServer rewardsDataContainer = new RewardsDataContainerServer(this);
    private final RewardsPlayerDataContainerServer playerDataContainer = new RewardsPlayerDataContainerServer(this);
    private final PlayersDataManagerServer playerDataManager = new PlayersDataManagerServer(this);

    private DailyRewardsManagerServer() {
    }

    private void registerPersistentData() {
        OxygenHelperServer.registerPersistentData(this.playerDataContainer::save);
    }

    private void scheduleRepeatableProcesses() {
        if (DailyRewardsConfig.REWARD_MODE.asInt() == 0) {
            ZonedDateTime reloadingTime;
            ZonedDateTime currentTime = TimeHelperServer.getZonedDateTime();
            if (currentTime.compareTo(reloadingTime = currentTime.withDayOfMonth(1).withHour(DailyRewardsConfig.REWARD_TIME_OFFSET_HOURS.asInt()).withMinute(0).withSecond(0)) > 0) {
                reloadingTime = reloadingTime.plusMonths(1L);
            }
            Month nextMonth = reloadingTime.getMonth();
            int nextMonthLength = reloadingTime.toLocalDate().isLeapYear() ? nextMonth.maxLength() : nextMonth.minLength();
            long initalDelay = Duration.between(currentTime, reloadingTime).getSeconds();
            OxygenHelperServer.getSchedulerExecutorService().scheduleAtFixedRate(this.rewardsDataContainer::reloadRewards, initalDelay, TimeUnit.DAYS.toSeconds(nextMonthLength), TimeUnit.SECONDS);
            OxygenMain.LOGGER.info("[Daily Rewards] Scheduled rewards reloading for <{}> at: {}", (Object)nextMonth.getDisplayName(TextStyle.FULL, Locale.ENGLISH), (Object)OxygenMain.DEBUG_DATE_TIME_FORMATTER.format(reloadingTime));
        }
    }

    public static void create() {
        if (instance == null) {
            instance = new DailyRewardsManagerServer();
            instance.registerPersistentData();
            instance.scheduleRepeatableProcesses();
        }
    }

    public static DailyRewardsManagerServer instance() {
        return instance;
    }

    public RewardsDataContainerServer getRewardsDataContainer() {
        return this.rewardsDataContainer;
    }

    public RewardsPlayerDataContainerServer getPlayerDataContainer() {
        return this.playerDataContainer;
    }

    public PlayersDataManagerServer getPlayerDataManager() {
        return this.playerDataManager;
    }

    public void worldLoaded() {
        OxygenHelperServer.addIOTask(this.rewardsDataContainer::loadRewardsData);
    }

    public void playerLoaded(EntityPlayerMP playerMP) {
        this.rewardsDataContainer.syncRewardsData(playerMP);
        this.playerDataManager.playerLoaded(playerMP);
    }
}

