/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.common.reward;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.InventoryProviderServer;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.reward.EnumReward;
import austeretony.oxygen_dailyrewards.common.reward.Reward;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RewardCommand
implements Reward {
    private String description;
    private String tooltip;
    private String commands;
    private int day;
    private int amount;
    private boolean special;
    private byte[] iconRaw;
    private ResourceLocation iconTexture;

    @Override
    public EnumReward getType() {
        return EnumReward.COMMAND;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public boolean isSpecial() {
        return this.special;
    }

    public static Reward fromJson(JsonObject jsonObject) {
        RewardCommand reward = new RewardCommand();
        reward.day = jsonObject.get("day").getAsInt();
        reward.description = jsonObject.get("description").getAsString();
        reward.special = jsonObject.get("special").getAsBoolean();
        reward.amount = jsonObject.has("amount") ? jsonObject.get("amount").getAsInt() : 0;
        reward.tooltip = jsonObject.get("tooltip").getAsString();
        reward.commands = jsonObject.get("commands").getAsString();
        reward.loadIconBytes(jsonObject.get("icon").getAsString());
        return reward;
    }

    private void loadIconBytes(String iconName) {
        String pathStr = CommonReference.getGameFolder() + "/config/oxygen/data/server/daily rewards/icons/" + iconName;
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(pathStr));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            this.iconRaw = baos.toByteArray();
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("[Daily Rewards] Failed to load reward icon: {}", (Object)iconName);
            exception.printStackTrace();
            this.iconRaw = new byte[0];
        }
    }

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeByte(this.day);
        ByteBufUtils.writeString((String)this.description, (ByteBuf)buffer);
        buffer.writeBoolean(this.special);
        ByteBufUtils.writeString((String)this.tooltip, (ByteBuf)buffer);
        buffer.writeInt(this.iconRaw.length);
        buffer.writeBytes(this.iconRaw);
        this.iconRaw = null;
    }

    public static Reward read(ByteBuf buffer) {
        RewardCommand reward = new RewardCommand();
        reward.day = buffer.readByte();
        reward.description = ByteBufUtils.readString((ByteBuf)buffer);
        reward.special = buffer.readBoolean();
        reward.tooltip = ByteBufUtils.readString((ByteBuf)buffer);
        reward.iconRaw = new byte[buffer.readInt()];
        buffer.readBytes(reward.iconRaw);
        return reward;
    }

    @Override
    public boolean rewardPlayer(EntityPlayerMP playerMP) {
        String[] commands;
        if (InventoryProviderServer.getPlayerInventory().getEmptySlotsAmount((EntityPlayer)playerMP) < this.amount) {
            OxygenManagerServer.instance().sendStatusMessage(playerMP, EnumOxygenStatusMessage.INVENTORY_FULL, new String[0]);
            return false;
        }
        for (String command : commands = this.commands.split("[;]")) {
            int result;
            if (command.contains("@p")) {
                command = command.replace("@p", CommonReference.getName((Entity)playerMP));
            }
            if (command.contains("@pX")) {
                command = command.replace("@pX", String.valueOf((int)playerMP.field_70165_t));
            }
            if (command.contains("@pY")) {
                command = command.replace("@pY", String.valueOf((int)playerMP.field_70163_u));
            }
            if (command.contains("@pZ")) {
                command = command.replace("@pZ", String.valueOf((int)playerMP.field_70161_v));
            }
            if (command.contains("@dim")) {
                command = command.replace("@dim", String.valueOf(playerMP.field_71093_bK));
            }
            if ((result = CommonReference.getServer().field_71321_q.func_71556_a((ICommandSender)CommonReference.getServer(), command)) != 0) continue;
            OxygenMain.LOGGER.info("[Daily Rewards] <{}/{}> Failed to execute command: {}", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)command);
        }
        if (DailyRewardsConfig.ADVANCED_LOGGING.asBoolean()) {
            OxygenMain.LOGGER.info("[Daily Rewards] <{}/{}> [2]: player rewarded with COMMAND - {}.", (Object)CommonReference.getName((Entity)playerMP), (Object)CommonReference.getPersistentUUID((Entity)playerMP), (Object)this.commands);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GUISimpleElement widget, int mouseX, int mouseY) {
        Minecraft mc = ClientReference.getMinecraft();
        int scaleFactor = (int)widget.getScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)widget.getX(), (float)widget.getY(), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(this.getIconTexture());
        GUIAdvancedElement.drawCustomSizedTexturedRect((int)0, (int)0, (int)0, (int)0, (int)(48 * scaleFactor), (int)(48 * scaleFactor), (int)(48 * scaleFactor), (int)(48 * scaleFactor));
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Nonnull
    private ResourceLocation getIconTexture() {
        if (this.iconTexture == null) {
            if (this.iconRaw.length > 0) {
                ByteArrayInputStream baos = new ByteArrayInputStream(this.iconRaw);
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(baos);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                this.iconRaw = null;
                if (bufferedImage != null) {
                    this.iconTexture = ClientReference.getMinecraft().func_110434_K().func_110578_a("reward_icon", new DynamicTexture(bufferedImage));
                    return this.iconTexture;
                }
            }
            ClientReference.getMinecraft().func_110434_K();
            this.iconTexture = TextureManager.field_194008_a;
        }
        return this.iconTexture;
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }
}

