/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_dailyrewards.client;

import austeretony.oxygen_core.client.api.PrivilegesProviderClient;
import austeretony.oxygen_core.client.api.TimeHelperClient;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_dailyrewards.client.DailyRewardsManagerClient;
import austeretony.oxygen_dailyrewards.common.config.DailyRewardsConfig;
import austeretony.oxygen_dailyrewards.common.main.EnumDailyRewardsPrivilege;
import java.time.Duration;
import java.time.ZonedDateTime;

public class RewardsPlayerDataClient {
    private int daysRewarded;
    private long lastRewardTimeMillis;

    public int getDaysRewarded() {
        return this.daysRewarded;
    }

    public long getLastRewardTimeMillis() {
        return this.lastRewardTimeMillis;
    }

    public void init(int daysRewarded, long lastRewardTimeMillis) {
        this.daysRewarded = daysRewarded;
        this.lastRewardTimeMillis = lastRewardTimeMillis;
        ZonedDateTime serverRewardTime = TimeHelperClient.getServerZonedDateTime((long)this.lastRewardTimeMillis);
        OxygenMain.LOGGER.info("[Daily Rewards] Player data synchronized - days rewarded this month: {}, last reward time: {}", (Object)this.daysRewarded, (Object)OxygenMain.DEBUG_DATE_TIME_FORMATTER.format(serverRewardTime));
    }

    public boolean isRewardAvailable() {
        boolean resetRewards;
        ZonedDateTime currentServerTime = TimeHelperClient.getServerZonedDateTime();
        ZonedDateTime lastTimePlayerRewarded = TimeHelperClient.getServerZonedDateTime((long)this.lastRewardTimeMillis);
        ZonedDateTime nextRewardTime = lastTimePlayerRewarded.plusDays(1L).withHour(DailyRewardsConfig.REWARD_TIME_OFFSET_HOURS.asInt()).withMinute(0).withSecond(0);
        boolean bl = DailyRewardsConfig.REWARD_MODE.asInt() == 0 ? lastTimePlayerRewarded.getMonthValue() != currentServerTime.getMonthValue() : (resetRewards = this.daysRewarded >= DailyRewardsManagerClient.instance().getRewardsDataContainer().getRewards().size());
        if (this.lastRewardTimeMillis != 0L && resetRewards && currentServerTime.getHour() >= DailyRewardsConfig.REWARD_TIME_OFFSET_HOURS.asInt()) {
            this.daysRewarded = 0;
        }
        int maximumRewards = PrivilegesProviderClient.getAsInt((int)EnumDailyRewardsPrivilege.MAXIMUM_REWARDS_AMOUNT_PER_MONTH.id(), (int)DailyRewardsConfig.MAXIMUM_REWARDS_PER_MONTH.asInt());
        if (!PrivilegesProviderClient.getAsBoolean((int)EnumDailyRewardsPrivilege.DAILY_REWARDS_ACCESS.id(), (boolean)DailyRewardsConfig.DAILY_REWARDS_ACCESS.asBoolean()) || this.daysRewarded >= maximumRewards) {
            return false;
        }
        return currentServerTime.compareTo(nextRewardTime) > 0;
    }

    public Duration getTimeLeftUntilNextReward() {
        ZonedDateTime currentServerTime = TimeHelperClient.getServerZonedDateTime();
        ZonedDateTime lastTimePlayerRewarded = TimeHelperClient.getServerZonedDateTime((long)this.lastRewardTimeMillis);
        ZonedDateTime nextRewardTime = lastTimePlayerRewarded.plusDays(1L).withHour(DailyRewardsConfig.REWARD_TIME_OFFSET_HOURS.asInt()).withMinute(0).withSecond(0);
        return Duration.between(currentServerTime, nextRewardTime);
    }
}

