/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.preset;

import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.server.preset.AbstractPresetServer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ItemCategoriesPresetServer
extends AbstractPresetServer {
    private final List<ItemCategory> categories = new ArrayList<ItemCategory>(5);

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public String getDirectory() {
        return "core/item categories";
    }

    @Override
    public String getName() {
        return "item_categories";
    }

    @Override
    public boolean loadFromFolder(String folder) {
        String pathStr = folder + "/item_categories.json";
        Path path = Paths.get(pathStr, new String[0]);
        this.categories.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                for (JsonElement categoryEntry : JsonUtils.getExternalJsonData(pathStr).getAsJsonArray()) {
                    this.categories.add(ItemCategory.deserialize(categoryEntry.getAsJsonObject()));
                }
                return true;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                JsonArray config = JsonUtils.getInternalJsonData("assets/oxygen_core/presets/item_categories.json").getAsJsonArray();
                for (JsonElement categoryEntry : config) {
                    this.categories.add(ItemCategory.deserialize(categoryEntry.getAsJsonObject()));
                }
                JsonUtils.createExternalJsonFile(pathStr, (JsonElement)config);
                return true;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void writeToBuf(ByteBuf buffer) {
        buffer.writeByte(this.categories.size());
        for (ItemCategory category : this.categories) {
            category.write(buffer);
        }
    }

    public static class ItemSubCategory {
        public final String name;
        private final Set<String> registryNames = new HashSet<String>();

        public ItemSubCategory(String name) {
            this.name = name;
        }

        protected static ItemSubCategory deserialize(JsonObject jsonObject) {
            ItemSubCategory subCategory = new ItemSubCategory(jsonObject.get("name").getAsString());
            for (JsonElement itemEntry : jsonObject.get("items").getAsJsonArray()) {
                subCategory.registryNames.add(itemEntry.getAsString());
            }
            return subCategory;
        }

        protected void write(ByteBuf buffer) {
            ByteBufUtils.writeString(this.name, buffer);
            buffer.writeShort(this.registryNames.size());
            for (String registryName : this.registryNames) {
                ByteBufUtils.writeString(registryName, buffer);
            }
        }
    }

    public static class ItemCategory {
        public final String name;
        private final List<ItemSubCategory> subCategories = new ArrayList<ItemSubCategory>(5);

        public ItemCategory(String name) {
            this.name = name;
        }

        public List<ItemSubCategory> getSubCategories() {
            return this.subCategories;
        }

        protected static ItemCategory deserialize(JsonObject jsonObject) {
            ItemCategory category = new ItemCategory(jsonObject.get("name").getAsString());
            for (JsonElement subCategoryEntry : jsonObject.get("sub_categories").getAsJsonArray()) {
                category.subCategories.add(ItemSubCategory.deserialize(subCategoryEntry.getAsJsonObject()));
            }
            return category;
        }

        protected void write(ByteBuf buffer) {
            ByteBufUtils.writeString(this.name, buffer);
            buffer.writeByte(this.subCategories.size());
            for (ItemSubCategory subCategory : this.subCategories) {
                subCategory.write(buffer);
            }
        }
    }
}

