/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.preset;

import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import austeretony.oxygen_core.server.preset.PresetServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public abstract class AbstractPresetServer
implements PresetServer {
    private long versionId;
    private final ByteBuf compressed = Unpooled.buffer();

    @Override
    public long getVersionId() {
        return this.versionId;
    }

    @Override
    public boolean load(String folder) {
        if (!this.loadVersionId(folder)) {
            return false;
        }
        boolean successful = this.loadFromFolder(folder);
        if (successful) {
            this.compress();
        }
        return successful;
    }

    public abstract boolean loadFromFolder(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadVersionId(String folder) {
        String pathStr = folder + this.getName() + "_version.txt";
        Path path = Paths.get(pathStr, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pathStr));){
                this.versionId = Long.parseLong(bufferedReader.readLine());
                boolean bl = true;
                return bl;
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return false;
            }
        }
        this.versionId = Long.parseLong(OxygenMain.ID_DATE_FORMAT.format(TimeHelperServer.getZonedDateTime()));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (PrintStream printStream = new PrintStream(new File(pathStr));){
                printStream.println(this.versionId);
                return true;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void compress() {
        this.compressed.writeLong(this.versionId);
        this.writeToBuf(this.compressed);
    }

    public abstract void writeToBuf(ByteBuf var1);

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeBytes(this.compressed, 0, this.compressed.writerIndex());
    }
}

