/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.event;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.config.PrivilegesConfig;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.server.api.PrivilegesProviderServer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PrivilegesEventsServer {
    @SubscribeEvent
    public void onChatMessage(ServerChatEvent event) {
        if (PrivilegesConfig.ENABLE_FORMATTED_CHAT.asBoolean()) {
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)event.getPlayer());
            Role role = PrivilegesProviderServer.getChatFormattingPlayerRole(playerUUID);
            if (role != null) {
                if (PrivilegesConfig.ENABLE_CUSTOM_FORMATTED_CHAT.asBoolean()) {
                    String result;
                    String prefix = null;
                    TextFormatting defColor = TextFormatting.values()[PrivilegesConfig.DEFAULT_CHAT_COLOR.asInt()];
                    if (!role.getPrefix().isEmpty()) {
                        prefix = role.getPrefixColor() + role.getPrefix() + TextFormatting.RESET;
                    }
                    String username = role.getUsernameColor() + CommonReference.getName((Entity)event.getPlayer()) + TextFormatting.RESET;
                    String string = result = !role.getPrefix().isEmpty() ? PrivilegesConfig.FORMATTED_CHAT_PREFIX_PATTERN.asString() : PrivilegesConfig.FORMATTED_CHAT_PATTERN.asString();
                    if (prefix != null) {
                        result = defColor + result.replace("@prefix", prefix + defColor);
                    }
                    result = result.replace("@username", username + defColor);
                    ITextComponent messageComponent = ForgeHooks.newChatWithLinks((String)event.getMessage());
                    messageComponent.func_150256_b().func_150238_a(role.getChatColor());
                    event.setComponent(new TextComponentString(result).func_150257_a(messageComponent));
                } else {
                    StringBuilder formattedUsername = new StringBuilder();
                    if (!role.getPrefix().isEmpty()) {
                        formattedUsername.append(role.getPrefixColor());
                        formattedUsername.append("[");
                        formattedUsername.append(role.getPrefix());
                        formattedUsername.append("]");
                        formattedUsername.append(TextFormatting.RESET);
                    }
                    formattedUsername.append(role.getUsernameColor());
                    formattedUsername.append(CommonReference.getName((Entity)event.getPlayer()));
                    formattedUsername.append(TextFormatting.RESET);
                    ITextComponent messageComponent = ForgeHooks.newChatWithLinks((String)event.getMessage());
                    messageComponent.func_150256_b().func_150238_a(role.getChatColor());
                    event.setComponent((ITextComponent)new TextComponentTranslation("chat.type.text", new Object[]{formattedUsername.toString(), messageComponent}));
                }
            } else if (PrivilegesConfig.ENABLE_CUSTOM_FORMATTED_CHAT.asBoolean()) {
                ITextComponent messageComponent = new TextComponentString(PrivilegesConfig.FORMATTED_CHAT_PATTERN.asString().replace("@username", CommonReference.getName((Entity)event.getPlayer()))).func_150257_a(ForgeHooks.newChatWithLinks((String)event.getMessage()));
                messageComponent.func_150256_b().func_150238_a(TextFormatting.values()[PrivilegesConfig.DEFAULT_CHAT_COLOR.asInt()]);
                event.setComponent(messageComponent);
            }
        }
    }
}

