/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.api;

import austeretony.oxygen_core.common.config.OxygenConfig;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.Role;
import austeretony.oxygen_core.common.value.TypedValueBoolean;
import austeretony.oxygen_core.common.value.TypedValueFloat;
import austeretony.oxygen_core.common.value.TypedValueInteger;
import austeretony.oxygen_core.common.value.TypedValueLong;
import austeretony.oxygen_core.common.value.TypedValueString;
import austeretony.oxygen_core.server.OxygenManagerServer;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class PrivilegesProviderServer {
    @Nullable
    public static Role getRole(int roleId) {
        return OxygenManagerServer.instance().getPrivilegesContainer().getRole(roleId);
    }

    @Nullable
    public static Set<Integer> getPlayerRolesIds(UUID playerUUID) {
        return OxygenManagerServer.instance().getPrivilegesContainer().getPlayerRolesIds(playerUUID);
    }

    @Nullable
    public static Role getChatFormattingPlayerRole(UUID playerUUID) {
        return OxygenManagerServer.instance().getPrivilegesManager().getChatFormattingPlayerRole(playerUUID);
    }

    @Nullable
    public static Role getPriorityPlayerRole(UUID playerUUID) {
        return OxygenManagerServer.instance().getPrivilegesManager().getPriorityPlayerRole(playerUUID);
    }

    @Nullable
    public static Privilege getPriorityPlayerPrivilege(UUID playerUUID, int privilegeId) {
        return OxygenManagerServer.instance().getPrivilegesManager().getPriorityPlayerPrivilege(playerUUID, privilegeId);
    }

    public static boolean getAsBoolean(UUID playerUUID, int privilegeId, boolean defaultValue) {
        Privilege privilege;
        if (OxygenConfig.ENABLE_PRIVILEGES.asBoolean() && (privilege = PrivilegesProviderServer.getPriorityPlayerPrivilege(playerUUID, privilegeId)) != null) {
            return ((TypedValueBoolean)privilege.get()).getValue();
        }
        return defaultValue;
    }

    public static int getAsInt(UUID playerUUID, int privilegeId, int defaultValue) {
        Privilege privilege;
        if (OxygenConfig.ENABLE_PRIVILEGES.asBoolean() && (privilege = PrivilegesProviderServer.getPriorityPlayerPrivilege(playerUUID, privilegeId)) != null) {
            return ((TypedValueInteger)privilege.get()).getValue();
        }
        return defaultValue;
    }

    public static long getAsLong(UUID playerUUID, int privilegeId, long defaultValue) {
        Privilege privilege;
        if (OxygenConfig.ENABLE_PRIVILEGES.asBoolean() && (privilege = PrivilegesProviderServer.getPriorityPlayerPrivilege(playerUUID, privilegeId)) != null) {
            return ((TypedValueLong)privilege.get()).getValue();
        }
        return defaultValue;
    }

    public static float getAsFloat(UUID playerUUID, int privilegeId, float defaultValue) {
        Privilege privilege;
        if (OxygenConfig.ENABLE_PRIVILEGES.asBoolean() && (privilege = PrivilegesProviderServer.getPriorityPlayerPrivilege(playerUUID, privilegeId)) != null) {
            return ((TypedValueFloat)privilege.get()).getValue().floatValue();
        }
        return defaultValue;
    }

    public static String getAsString(UUID playerUUID, int privilegeId, String defaultValue) {
        Privilege privilege;
        if (OxygenConfig.ENABLE_PRIVILEGES.asBoolean() && (privilege = PrivilegesProviderServer.getPriorityPlayerPrivilege(playerUUID, privilegeId)) != null) {
            return ((TypedValueString)privilege.get()).getValue();
        }
        return defaultValue;
    }
}

