/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server;

import austeretony.oxygen_core.common.EnumActivityStatus;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncObservedPlayersData;
import austeretony.oxygen_core.common.network.client.CPSyncSharedData;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.ObservedPlayersContainer;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.event.OxygenActivityStatusChangedEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SharedDataManagerServer
extends AbstractPersistentData {
    private final Map<UUID, PlayerSharedData> sharedData = new ConcurrentHashMap<UUID, PlayerSharedData>();
    private final Map<UUID, ObservedPlayersContainer> observedPlayers = new ConcurrentHashMap<UUID, ObservedPlayersContainer>();
    private final Map<Integer, UUID> access = new ConcurrentHashMap<Integer, UUID>();
    private final Set<SharedDataRegistryEntry> sharedDataRegistry = new HashSet<SharedDataRegistryEntry>();
    private final ByteBuf compressedSharedData = Unpooled.buffer();
    private volatile long nextUpdateTimeMillis;

    public void registerSharedDataValue(int id, int size) {
        this.sharedDataRegistry.add(new SharedDataRegistryEntry(id, size));
    }

    public Set<Integer> getOnlinePlayersIndexes() {
        return this.access.keySet();
    }

    public Collection<UUID> getOnlinePlayersUUIDs() {
        return this.access.values();
    }

    public Collection<PlayerSharedData> getPlayersSharedData() {
        return this.sharedData.values();
    }

    @Nullable
    public PlayerSharedData getSharedData(int index) {
        return this.sharedData.get(this.access.get(index));
    }

    @Nullable
    public PlayerSharedData getSharedData(UUID playerUUID) {
        return this.sharedData.get(playerUUID);
    }

    @Nullable
    public PlayerSharedData getSharedData(String username) {
        for (PlayerSharedData sharedData : this.sharedData.values()) {
            if (!sharedData.getUsername().equals(username)) continue;
            return sharedData;
        }
        return null;
    }

    public void addObservedPlayer(UUID observer, UUID observed) {
        ObservedPlayersContainer container = this.observedPlayers.get(observer);
        if (container != null) {
            this.observedPlayers.get(observer).addObservedPlayer(observed);
        } else {
            container = new ObservedPlayersContainer();
            container.addObservedPlayer(observed);
            this.observedPlayers.put(observer, container);
        }
        this.setChanged(true);
    }

    public void removeObservedPlayer(UUID observer, UUID observed) {
        ObservedPlayersContainer container = this.observedPlayers.get(observer);
        if (container != null) {
            container.removeObservedPlayer(observed);
            if (container.isEmpty()) {
                this.observedPlayers.remove(observer);
            }
        }
        this.setChanged(true);
    }

    public ObservedPlayersContainer getObservedPlayersContainer(UUID playerUUID) {
        return this.observedPlayers.get(playerUUID);
    }

    public void createSharedDataEntry(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        PlayerSharedData newSharedData = new PlayerSharedData();
        newSharedData.setPlayerUUID(playerUUID);
        newSharedData.setUsername(CommonReference.getName((Entity)playerMP));
        newSharedData.setIndex(CommonReference.getEntityId((Entity)playerMP));
        newSharedData.updateLastActivityTime();
        for (SharedDataRegistryEntry entry : this.sharedDataRegistry) {
            newSharedData.createDataBuffer(entry.id, entry.size);
        }
        newSharedData.setByte(0, OxygenHelperServer.getOxygenPlayerData(playerUUID).getActivityStatus().ordinal());
        newSharedData.setInt(1, playerMP.field_71093_bK);
        this.sharedData.put(playerUUID, newSharedData);
        this.access.put(CommonReference.getEntityId((Entity)playerMP), playerUUID);
        this.syncObservedPlayersData(playerMP);
        OxygenManagerServer.instance().getPrivilegesManager().updatePlayerRolesSharedData(playerUUID);
        this.setChanged(true);
    }

    public void removeSharedDataEntry(UUID playerUUID) {
        PlayerSharedData sharedData = this.getSharedData(playerUUID);
        sharedData.updateLastActivityTime();
        this.access.remove(sharedData.getIndex());
        this.setChanged(true);
    }

    public void updateActivityStatus(EntityPlayerMP playerMP, EnumActivityStatus status) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        PlayerSharedData sharedData = this.getSharedData(playerUUID);
        int prevStatus = sharedData.getByte(0);
        sharedData.setByte(0, status.ordinal());
        if (status == EnumActivityStatus.OFFLINE) {
            sharedData.updateLastActivityTime();
            this.sharedData.put(playerUUID, sharedData);
        }
        CommonReference.delegateToServerThread(() -> MinecraftForge.EVENT_BUS.post((Event)new OxygenActivityStatusChangedEvent(playerMP, EnumActivityStatus.values()[prevStatus], status)));
        this.setChanged(true);
    }

    public void updateDimension(UUID playerUUID, int dimension) {
        if (!OxygenHelperServer.isOfflineActivityStatus(playerUUID)) {
            this.getSharedData(playerUUID).setInt(1, dimension);
        }
        this.setChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncObservedPlayersData(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        ObservedPlayersContainer container = this.getObservedPlayersContainer(playerUUID);
        if (container != null) {
            ByteBuf buffer = null;
            try {
                buffer = Unpooled.buffer();
                buffer.writeShort(container.getObservedPlayersAmount());
                for (UUID uuid : container.getObservedPlayers()) {
                    this.sharedData.get(uuid).write(buffer);
                }
                byte[] compressed = new byte[buffer.writerIndex()];
                buffer.getBytes(0, compressed);
                OxygenMain.network().sendTo(new CPSyncObservedPlayersData(compressed), playerMP);
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncSharedData(EntityPlayerMP playerMP, int id) {
        ByteBuf byteBuf = this.compressedSharedData;
        synchronized (byteBuf) {
            if (System.currentTimeMillis() > this.nextUpdateTimeMillis) {
                this.nextUpdateTimeMillis = System.currentTimeMillis() + 1000L;
                this.compressedSharedData.clear();
                this.compressedSharedData.writeShort(this.access.size());
                for (int index : this.access.keySet()) {
                    UUID playerUUID = this.access.get(index);
                    this.sharedData.get(playerUUID).write(this.compressedSharedData);
                }
            }
            byte[] compressed = new byte[this.compressedSharedData.writerIndex()];
            this.compressedSharedData.getBytes(0, compressed);
            OxygenMain.network().sendTo(new CPSyncSharedData(id, compressed), playerMP);
        }
    }

    @Override
    public String getDisplayName() {
        return "core:shared_data_server";
    }

    @Override
    public String getPath() {
        return OxygenHelperServer.getDataFolder() + "/server/world/core/persistent.dat";
    }

    @Override
    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write(this.sharedData.size(), (OutputStream)bos);
        for (PlayerSharedData playerSharedData : this.sharedData.values()) {
            playerSharedData.write(bos);
        }
        StreamUtils.write(this.observedPlayers.size(), (OutputStream)bos);
        for (Map.Entry entry : this.observedPlayers.entrySet()) {
            StreamUtils.write((UUID)entry.getKey(), (OutputStream)bos);
            ((ObservedPlayersContainer)entry.getValue()).write(bos);
        }
    }

    @Override
    public void read(BufferedInputStream bis) throws IOException {
        int i;
        int amount = StreamUtils.readInt(bis);
        for (i = 0; i < amount; ++i) {
            PlayerSharedData sharedData = PlayerSharedData.read(bis);
            this.sharedData.put(sharedData.getPlayerUUID(), sharedData);
        }
        OxygenMain.LOGGER.info("[Core] Loaded {} players shared data entries.", (Object)amount);
        amount = StreamUtils.readInt(bis);
        for (i = 0; i < amount; ++i) {
            UUID playerUUID = StreamUtils.readUUID(bis);
            this.observedPlayers.put(playerUUID, ObservedPlayersContainer.read(bis));
        }
    }

    @Override
    public void reset() {
        this.sharedData.clear();
        this.observedPlayers.clear();
        this.access.clear();
    }

    public static class SharedDataRegistryEntry {
        public final int id;
        public final int size;

        public SharedDataRegistryEntry(int id, int size) {
            this.id = id;
            this.size = size;
        }
    }
}

