/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.server.api.TimeHelperServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ServerData {
    public String worldFolder;
    private String dataFolder;
    private long worldId;

    public String getDataFolder() {
        return this.dataFolder;
    }

    public long getWorldId() {
        return this.worldId;
    }

    public void createOrLoadWorldId(String worldFolder) {
        this.worldFolder = worldFolder;
        this.createOrLoadWorldId();
    }

    private void createOrLoadWorldId() {
        String worldIdFilePathStr = this.worldFolder + "/oxygen/worldid.txt";
        Path worldIdPath = Paths.get(worldIdFilePathStr, new String[0]);
        if (Files.exists(worldIdPath, new LinkOption[0])) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(worldIdFilePathStr));){
                String worldIdStr = bufferedReader.readLine();
                this.worldId = Long.parseLong(worldIdStr);
                OxygenMain.LOGGER.info("[Core] Loaded world id: {}", (Object)worldIdStr);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] World id loading failed.");
                exception.printStackTrace();
            }
        } else {
            this.worldId = Long.parseLong(OxygenMain.ID_DATE_FORMAT.format(TimeHelperServer.getZonedDateTime()));
            String worldIdStr = String.valueOf(this.worldId);
            OxygenMain.LOGGER.info("[Core] Created world id: {}", (Object)worldIdStr);
            try {
                Files.createDirectories(worldIdPath.getParent(), new FileAttribute[0]);
                try (PrintStream printStream = new PrintStream(new File(worldIdFilePathStr));){
                    printStream.println(worldIdStr);
                }
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("[Core] World id saving failed.");
                exception.printStackTrace();
            }
        }
        this.dataFolder = CommonReference.getGameFolder() + "/oxygen/worlds/" + this.worldId;
    }
}

