/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class StreamUtils {
    public static void write(byte[] bytes, OutputStream os) throws IOException {
        os.write(bytes);
    }

    public static void write(boolean flag, OutputStream os) throws IOException {
        os.write(flag ? 1 : 0);
    }

    public static void write(byte value, OutputStream os) throws IOException {
        os.write(value);
    }

    public static void write(short value, OutputStream os) throws IOException {
        os.write(value >> 8);
        os.write(value);
    }

    public static void write(int value, OutputStream os) throws IOException {
        os.write(value >> 24);
        os.write(value >> 16);
        os.write(value >> 8);
        os.write(value);
    }

    public static void write(long value, OutputStream os) throws IOException {
        os.write((byte)value);
        os.write((byte)(value >> 8));
        os.write((byte)(value >> 16));
        os.write((byte)(value >> 24));
        os.write((byte)(value >> 32));
        os.write((byte)(value >> 40));
        os.write((byte)(value >> 48));
        os.write((byte)(value >> 56));
    }

    public static void write(float value, OutputStream os) throws IOException {
        StreamUtils.write(Float.floatToIntBits(value), os);
    }

    public static void write(double value, OutputStream os) throws IOException {
        StreamUtils.write(Double.doubleToLongBits(value), os);
    }

    public static void write(String value, OutputStream os) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        StreamUtils.write((short)bytes.length, os);
        os.write(bytes);
    }

    public static void write(UUID uuid, OutputStream os) throws IOException {
        StreamUtils.write(uuid.getMostSignificantBits(), os);
        StreamUtils.write(uuid.getLeastSignificantBits(), os);
    }

    public static void readBytes(byte[] bytes, InputStream is) throws IOException {
        is.read(bytes);
    }

    public static boolean readBoolean(InputStream is) throws IOException {
        return is.read() != 0;
    }

    public static int readByte(InputStream is) throws IOException {
        int value = is.read();
        return value > -1 ? (int)value : value;
    }

    public static int readShort(InputStream is) throws IOException {
        return is.read() << 8 | is.read() & 0xFF;
    }

    public static int readInt(InputStream is) throws IOException {
        return is.read() << 24 | (is.read() & 0xFF) << 16 | (is.read() & 0xFF) << 8 | is.read() & 0xFF;
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] bytes = new byte[8];
        is.read(bytes);
        return ((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
    }

    public static float readFloat(InputStream is) throws IOException {
        return Float.intBitsToFloat(StreamUtils.readInt(is));
    }

    public static double readDouble(InputStream is) throws IOException {
        return Double.longBitsToDouble(StreamUtils.readLong(is));
    }

    public static String readString(InputStream is) throws IOException {
        byte[] bytes = new byte[StreamUtils.readShort(is)];
        is.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static UUID readUUID(InputStream is) throws IOException {
        return new UUID(StreamUtils.readLong(is), StreamUtils.readLong(is));
    }
}

