/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.sound;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OxygenSoundEffects {
    private static final Map<Integer, SoundEventContainer> REGISTRY = new HashMap<Integer, SoundEventContainer>(7);
    public static final SoundEventContainer INVENTORY_OPERATION = new SoundEventContainer("oxygen_core", "inventory_operation");
    public static final SoundEventContainer RINGING_COINS = new SoundEventContainer("oxygen_core", "ringing_coins");
    public static final SoundEventContainer NOTIFICATION_RECEIVED = new SoundEventContainer("oxygen_core", "request_recieved");
    public static final SoundEventContainer BUTTON_CLICK = new SoundEventContainer("oxygen_core", "button_click");
    public static final SoundEventContainer CONTEXT_OPEN = new SoundEventContainer("oxygen_core", "context_open");
    public static final SoundEventContainer CONTEXT_CLOSE = new SoundEventContainer("oxygen_core", "context_close");
    public static final SoundEventContainer DROP_DOWN_LIST_OPEN = new SoundEventContainer("oxygen_core", "drop_down_list_open");

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{INVENTORY_OPERATION.getSoundEvent(), RINGING_COINS.getSoundEvent(), NOTIFICATION_RECEIVED.getSoundEvent(), BUTTON_CLICK.getSoundEvent(), CONTEXT_OPEN.getSoundEvent(), CONTEXT_CLOSE.getSoundEvent(), DROP_DOWN_LIST_OPEN.getSoundEvent()});
    }

    public static SoundEvent getSoundEvent(int id) {
        return REGISTRY.get(id).getSoundEvent();
    }

    public static class SoundEventContainer {
        private final SoundEvent soundEvent;
        private final int id;

        public SoundEventContainer(String modId, String name) {
            ResourceLocation location = new ResourceLocation(modId, name);
            this.soundEvent = (SoundEvent)new SoundEvent(location).setRegistryName(location);
            this.id = REGISTRY.size();
            REGISTRY.put(this.id, this);
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }

        public int getId() {
            return this.id;
        }
    }
}

