/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.persistent;

import austeretony.oxygen_core.common.concurrent.OxygenExecutionManager;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.persistent.OxygenIOManager;
import austeretony.oxygen_core.common.persistent.PersistentData;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PersistentDataManager {
    private final OxygenExecutionManager executionManager;
    private final OxygenIOManager ioManager;
    private final int savePeriodSeconds;
    private final Set<PersistentData> containers = new HashSet<PersistentData>();
    private final Set<Runnable> tasks = new HashSet<Runnable>();

    public PersistentDataManager(OxygenExecutionManager executionManager, OxygenIOManager ioManager, int savePeriodSeconds) {
        this.executionManager = executionManager;
        this.ioManager = ioManager;
        this.savePeriodSeconds = savePeriodSeconds;
        Runnable task = () -> {
            for (PersistentData container : this.containers) {
                if (!container.isChanged()) continue;
                container.setChanged(false);
                this.ioManager.savePersistentDataAsync(container);
            }
            for (Runnable r : this.tasks) {
                r.run();
            }
        };
        this.executionManager.getExecutors().getSchedulerExecutorService().scheduleAtFixedRate(task, this.savePeriodSeconds, this.savePeriodSeconds, TimeUnit.SECONDS);
    }

    public void registerPersistentData(PersistentData data) {
        this.containers.add(data);
        OxygenMain.LOGGER.info("[Core] Registered <{}> persistent data.", (Object)data.getDisplayName());
    }

    public void registerPersistentData(Runnable task) {
        this.tasks.add(task);
    }

    public void worldUnloaded() {
        OxygenMain.LOGGER.info("[Core] Forcing persistent data save on world unload...");
        for (PersistentData data : this.containers) {
            if (!data.isChanged()) continue;
            data.setChanged(false);
            this.ioManager.savePersistentDataAsync(data);
            OxygenMain.LOGGER.info("[Core] Persistent data <{}> saved.", (Object)data.getDisplayName());
        }
        for (Runnable r : this.tasks) {
            r.run();
        }
    }
}

