/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPDefaultPrivilegeOperation
extends Packet {
    private int ordinal;
    private int privilegeId;
    private String privilegeValue;

    public SPDefaultPrivilegeOperation() {
    }

    public SPDefaultPrivilegeOperation(EnumOperation operation, int privilegeId, String privilegeValue) {
        this.ordinal = operation.ordinal();
        this.privilegeId = privilegeId;
        this.privilegeValue = privilegeValue;
    }

    @Override
    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeShort(this.privilegeId);
        ByteBufUtils.writeString(this.privilegeValue, buffer);
    }

    @Override
    public void read(ByteBuf buffer, INetHandler netHandler) {
        byte ordinal;
        EntityPlayerMP playerMP = SPDefaultPrivilegeOperation.getEntityPlayerMP(netHandler);
        if (OxygenHelperServer.isNetworkRequestAvailable(CommonReference.getPersistentUUID((Entity)playerMP), 4) && (ordinal = buffer.readByte()) >= 0 && ordinal < EnumOperation.values().length) {
            short privilegeId = buffer.readShort();
            String value = ByteBufUtils.readString(buffer);
            switch (EnumOperation.values()[ordinal]) {
                case ADD: {
                    OxygenHelperServer.addRoutineTask(() -> OxygenManagerServer.instance().getPrivilegesManager().addDefaultPrivilege(playerMP, privilegeId, value));
                    break;
                }
                case REMOVE: {
                    OxygenHelperServer.addRoutineTask(() -> OxygenManagerServer.instance().getPrivilegesManager().removeDefaultPrivilege(playerMP, privilegeId));
                }
            }
        }
    }

    public static enum EnumOperation {
        ADD,
        REMOVE;

    }
}

