/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPAbsentDataIds
extends Packet {
    private int dataId;
    private int amount;
    private long[] ids;

    public SPAbsentDataIds() {
    }

    public SPAbsentDataIds(int dataId, long[] ids, int amount) {
        this.dataId = dataId;
        this.ids = ids;
        this.amount = amount;
    }

    @Override
    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeShort(this.dataId);
        buffer.writeShort(this.amount);
        for (long entryId : this.ids) {
            if (entryId == 0L) break;
            buffer.writeLong(entryId);
        }
    }

    @Override
    public void read(ByteBuf buffer, INetHandler netHandler) {
        long[] ids;
        EntityPlayerMP playerMP = SPAbsentDataIds.getEntityPlayerMP(netHandler);
        short dataId = buffer.readShort();
        if (OxygenHelperServer.isNetworkRequestAvailable(CommonReference.getPersistentUUID((Entity)playerMP), dataId + 2000) && (ids = new long[buffer.readShort()]).length > 0 && buffer.readableBytes() > 0) {
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = buffer.readLong();
            }
            OxygenHelperServer.addRoutineTask(() -> OxygenManagerServer.instance().getDataSyncManager().syncAbsentData(playerMP, dataId, ids));
        }
    }
}

