/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.condition;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public enum EnumComparisonOperation {
    EQUAL("=="),
    NOT_EQUAL("!="),
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LESS_OR_EQUAL("<="),
    GREATER_OR_EQUAL(">=");

    public static final Map<String, EnumComparisonOperation> OPERATIONS;
    private final String operation;

    private EnumComparisonOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    @Nullable
    public static EnumComparisonOperation parseOperation(String operationStr) {
        return OPERATIONS.get(operationStr);
    }

    static {
        OPERATIONS = Maps.newHashMap();
        for (EnumComparisonOperation operation : EnumComparisonOperation.values()) {
            OPERATIONS.put(operation.getOperation(), operation);
        }
    }
}

