/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.preset;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.preset.PresetClient;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.server.SPRequestPresetSync;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class PresetsManagerClient {
    private final List<PresetClient> presets = new ArrayList<PresetClient>(5);

    public void registerPreset(PresetClient preset) {
        this.presets.add(preset);
    }

    public void presetsVersionsReceived(long[] data) {
        OxygenHelperClient.addIOTask(() -> {
            OxygenMain.LOGGER.info("[Core] Presets loading started...");
            String folder = CommonReference.getGameFolder() + "/config/oxygen/data/client/worlds/" + data[0] + "/";
            for (PresetClient preset : this.presets) {
                if (preset.loadVersionId(folder + "/presets/" + preset.getDirectory() + "/")) {
                    OxygenMain.LOGGER.info("[Core] Preset <{}> version id loaded successfully.", (Object)preset.getName());
                    continue;
                }
                OxygenMain.LOGGER.error("[Core] Failed to load preset <{}> version id.", (Object)preset.getName());
            }
            int index = 1;
            for (PresetClient preset : this.presets) {
                if (preset.getVersionId() != data[index++]) {
                    OxygenMain.network().sendToServer(new SPRequestPresetSync(preset.getId()));
                    OxygenMain.LOGGER.info("[Core] Preset <{}> is outdated, sync requested.", (Object)preset.getName());
                    continue;
                }
                OxygenMain.LOGGER.info("[Core] Preset <{}> is up-to-date, loading...", (Object)preset.getName());
                if (preset.load(folder + "/presets/" + preset.getDirectory() + "/")) {
                    OxygenMain.LOGGER.info("[Core] Preset <{}> loaded successfully.", (Object)preset.getName());
                    continue;
                }
                OxygenMain.LOGGER.error("[Core] Failed to load preset <{}>.", (Object)preset.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawPresetReceived(ByteBuf buffer) {
        try {
            long worldId = buffer.readLong();
            byte presetId = buffer.readByte();
            String folder = CommonReference.getGameFolder() + "/config/oxygen/data/client/worlds/" + worldId + "/";
            for (PresetClient preset : this.presets) {
                if (preset.getId() != presetId) continue;
                OxygenMain.LOGGER.info("[Core] Received raw preset <{}> data, processing...", (Object)preset.getName());
                preset.read(buffer);
                OxygenHelperClient.addIOTask(() -> {
                    if (preset.save(folder + "/presets/" + preset.getDirectory() + "/")) {
                        OxygenMain.LOGGER.info("[Core] Preset <{}> saved successfully.", (Object)preset.getName());
                    } else {
                        OxygenMain.LOGGER.error("[Core] Failed to save preset <{}>.", (Object)preset.getName());
                    }
                    if (preset.reloadAfterSave()) {
                        OxygenMain.LOGGER.info("[Core] Reloading preset <{}>...", (Object)preset.getName());
                        if (preset.load(folder + "/presets/" + preset.getDirectory() + "/")) {
                            OxygenMain.LOGGER.info("[Core] Preset <{}> loaded successfully.", (Object)preset.getName());
                        } else {
                            OxygenMain.LOGGER.error("[Core] Failed to load preset <{}>.", (Object)preset.getName());
                        }
                    }
                });
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }
}

