/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.privileges.management.players;

import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenWrapperPanelEntry;
import austeretony.oxygen_core.client.privilege.RoleData;
import austeretony.oxygen_core.common.EnumActivityStatus;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.util.OxygenUtils;
import java.util.UUID;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

public class PlayerPanelEntry
extends OxygenWrapperPanelEntry<UUID> {
    private String lastActivity;
    private String username;
    private String dimension;
    private int tooltipBackgroundColor;
    private int tooltipFrameColor;
    private int statusIconU;
    private int rolesAmount;
    private int rolesWidth;
    private boolean offline;
    private String[] roles = new String[5];

    public PlayerPanelEntry(PlayerSharedData sharedData) {
        super(sharedData.getPlayerUUID());
        this.lastActivity = ClientReference.localize("oxygen_core.gui.lastActivityTime", OxygenUtils.getTimePassedLocalizedString(sharedData.getLastActivityTime()));
        EnumActivityStatus activityStatus = OxygenHelperClient.getPlayerActivityStatus(sharedData);
        this.statusIconU = activityStatus.ordinal() * 3;
        this.offline = activityStatus == EnumActivityStatus.OFFLINE;
        this.username = sharedData.getUsername();
        this.dimension = OxygenHelperClient.getDimensionName(OxygenHelperClient.getPlayerDimension(sharedData));
        this.tooltipBackgroundColor = EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt();
        this.tooltipFrameColor = EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt();
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.setTooltipScaleFactor(EnumBaseGUISetting.TEXT_TOOLTIP_SCALE.get().asFloat());
        for (int i = 0; i < this.roles.length; ++i) {
            int roleId = sharedData.getByte(i + 10);
            if (roleId == -1) continue;
            RoleData roleData = OxygenManagerClient.instance().getPrivilegesContainer().getRoleData(roleId);
            this.roles[i] = roleData != null ? roleData.nameColor + roleData.name : TextFormatting.ITALIC + "Undefined";
            this.rolesAmount = i + 1;
            int width = this.textWidth(roleData.name, this.getTooltipScaleFactor()) + 4;
            if (this.rolesWidth >= width) continue;
            this.rolesWidth = width;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            int textColor;
            int color;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredBackgroundColor();
                textColor = this.getHoveredTextColor();
            } else {
                color = this.getEnabledBackgroundColor();
                textColor = this.getEnabledTextColor();
            }
            int third = this.getWidth() / 3;
            OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, color, EnumGUIAlignment.RIGHT);
            PlayerPanelEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), color);
            OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, color, EnumGUIAlignment.LEFT);
            int textY = (this.getHeight() - this.textHeight(this.getTextScale())) / 2 + 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)18.0f, (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.username, 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)120.0f, (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.dimension, 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.STATUS_ICONS);
            PlayerPanelEntry.drawCustomSizedTexturedRect(7, 4, this.statusIconU, 0, 3, 3, 12, 3);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.offline && mouseX >= this.getX() + 7 && mouseY >= this.getY() + 4 && mouseX < this.getX() + 10 && mouseY < this.getY() + 7) {
            this.drawLastActivityTimeTooltip(mouseX, mouseY, this.lastActivity);
        }
        if (this.rolesAmount != 0 && mouseX >= this.getX() + 18 && mouseY >= this.getY() + 1 && mouseX < this.getX() + 60 && mouseY < this.getY() + 9) {
            this.drawRoles(mouseX, mouseY);
        }
    }

    private void drawLastActivityTimeTooltip(int mouseX, int mouseY, String text) {
        int width = this.textWidth(text, this.getTooltipScaleFactor()) + 6;
        int height = 9;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)mouseX, (float)(mouseY - height - 2), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PlayerPanelEntry.drawRect(0, 0, width, height, this.tooltipBackgroundColor);
        OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, height, this.tooltipFrameColor);
        OxygenGUIUtils.drawRect((double)width - 0.4, 0.0, width, height, this.tooltipFrameColor);
        OxygenGUIUtils.drawRect(0.0, 0.0, width, 0.4, this.tooltipFrameColor);
        OxygenGUIUtils.drawRect(0.0, (double)height - 0.4, width, height, this.tooltipFrameColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((width - this.textWidth(text, this.getTooltipScaleFactor())) / 2), (float)((float)((height - this.textHeight(this.getTooltipScaleFactor())) / 2) + 1.0f), (float)0.0f);
        GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
        this.mc.field_71466_p.func_175065_a(text, 0.0f, 0.0f, this.getEnabledTextColor(), false);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private void drawRoles(int mouseX, int mouseY) {
        int height = 9;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)mouseX, (float)(mouseY - height * this.rolesAmount), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PlayerPanelEntry.drawRect(0, 0, this.rolesWidth, height * this.rolesAmount, this.tooltipBackgroundColor);
        OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, (double)height * (double)this.rolesAmount, this.tooltipFrameColor);
        OxygenGUIUtils.drawRect((double)this.rolesWidth - 0.4, 0.0, this.rolesWidth, (double)height * (double)this.rolesAmount, this.tooltipFrameColor);
        OxygenGUIUtils.drawRect(0.0, 0.0, this.rolesWidth, 0.4, this.tooltipFrameColor);
        OxygenGUIUtils.drawRect(0.0, (double)height * (double)this.rolesAmount - 0.4, this.rolesWidth, (double)height * (double)this.rolesAmount, this.tooltipFrameColor);
        for (int i = 0; i < this.rolesAmount; ++i) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(i * height + (height - this.textHeight(this.getTooltipScaleFactor())) / 2) + 1.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.roles[i], 0.0f, 0.0f, this.getEnabledTextColor(), false);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }
}

