/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.notifications;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenTexturedButton;
import austeretony.oxygen_core.common.notification.EnumNotification;
import austeretony.oxygen_core.common.notification.Notification;
import net.minecraft.client.renderer.GlStateManager;

public class NotificationPanelEntry
extends GUIButton {
    private Notification notification;
    private OxygenTexturedButton acceptButton;
    private OxygenTexturedButton rejectButton;

    public NotificationPanelEntry(Notification notification) {
        this.notification = notification;
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt());
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
    }

    @Override
    public void init() {
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat());
        this.setDisplayText(ClientReference.localize(this.notification.getDescription(), this.notification.getArguments()));
        this.acceptButton = (OxygenTexturedButton)new OxygenTexturedButton(2, 2, 6, 6, OxygenGUITextures.CHECK_ICONS, 6, 6, "").initScreen(this.getScreen());
        this.rejectButton = (OxygenTexturedButton)new OxygenTexturedButton(12, 2, 6, 6, OxygenGUITextures.CROSS_ICONS, 6, 6, "").initScreen(this.getScreen());
        if (this.notification.getType() == EnumNotification.NOTIFICATION) {
            this.rejectButton.disableFull();
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            int color = this.getEnabledBackgroundColor();
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                color = this.getHoveredBackgroundColor();
                textColor = this.getHoveredTextColor();
            }
            int third = this.getWidth() / 3;
            OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, color, EnumGUIAlignment.RIGHT);
            NotificationPanelEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), color);
            OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, color, EnumGUIAlignment.LEFT);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)11.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            if (this.notification.getType() == EnumNotification.REQUEST) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)22.0f, (float)3.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
                this.mc.field_71466_p.func_175065_a("(" + String.valueOf((this.notification.getExpirationTimeStamp() - System.currentTimeMillis()) / 1000L) + ")", 0.0f, 0.0f, textColor, true);
                GlStateManager.func_179121_F();
            }
            this.acceptButton.draw(mouseX, mouseY);
            this.rejectButton.draw(mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.acceptButton.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.notification.accepted(ClientReference.getClientPlayer());
            return true;
        }
        if (this.rejectButton.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.notification.rejected(ClientReference.getClientPlayer());
            return true;
        }
        return false;
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        this.acceptButton.mouseOver(mouseX - this.getX(), mouseY - this.getY());
        this.rejectButton.mouseOver(mouseX - this.getX(), mouseY - this.getY());
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + (int)((float)this.getWidth() * this.getScale()) && mouseY < this.getY() + (int)((float)this.getHeight() * this.getScale()));
    }
}

