/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.PrivilegesProviderClient;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenTextField;
import austeretony.oxygen_core.common.EnumActivityStatus;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.main.EnumOxygenPrivilege;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenUsernameField
extends OxygenTextField {
    private final Set<String> usernames = new TreeSet<String>();
    private UsernameFieldEntry[] elements = new UsernameFieldEntry[5];
    private int elementsAmount;
    private int baseColorHex = EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt();
    private int additionalColorHex = EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt();
    @Nullable
    private UsernameSelectListener usernameSelectListener;
    private boolean active;

    public OxygenUsernameField(int xPosition, int yPosition, int width) {
        super(xPosition, yPosition, width, 24, "");
        this.cancelDraggedElementLogic(false);
    }

    public void setUsernameSelectListener(UsernameSelectListener listener) {
        this.usernameSelectListener = listener;
    }

    public void load() {
        for (PlayerSharedData sharedData : OxygenHelperClient.getPlayersSharedData()) {
            if (!this.isPlayerAvailable(sharedData)) continue;
            this.usernames.add(sharedData.getUsername());
        }
        this.usernames.remove(OxygenHelperClient.getPlayerUsername());
    }

    private boolean isPlayerAvailable(PlayerSharedData sharedData) {
        if (sharedData.getPlayerUUID().equals(OxygenHelperClient.getPlayerUUID())) {
            return false;
        }
        return sharedData != null && OxygenHelperClient.isPlayerOnline(sharedData.getIndex()) && PrivilegesProviderClient.getAsBoolean(EnumOxygenPrivilege.EXPOSE_OFFLINE_PLAYERS.id(), OxygenHelperClient.getPlayerActivityStatus(sharedData) != EnumActivityStatus.OFFLINE);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        if (this.isDragged() && this.active) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            OxygenUsernameField.drawRect(0, this.getHeight(), this.getWidth(), (this.getHeight() + 1) * (this.elementsAmount + 1), this.baseColorHex);
            OxygenGUIUtils.drawRect(0.0, this.getHeight(), 0.4, (double)(this.getHeight() * (this.elementsAmount + 1)) - 0.4, this.additionalColorHex);
            OxygenGUIUtils.drawRect((double)this.getWidth() - 0.4, this.getHeight(), this.getWidth(), (double)(this.getHeight() * (this.elementsAmount + 1)) - 0.4, this.additionalColorHex);
            OxygenGUIUtils.drawRect(0.0, (double)this.getHeight() + 0.4, this.getWidth(), this.getHeight(), this.additionalColorHex);
            OxygenGUIUtils.drawRect(0.0, this.getHeight() * (this.elementsAmount + 1), this.getWidth(), (double)(this.getHeight() * (this.elementsAmount + 1)) + 0.4, this.additionalColorHex);
            GlStateManager.func_179121_F();
            for (UsernameFieldEntry element : this.elements) {
                if (element == null) continue;
                element.draw(mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            super.mouseOver(mouseX, mouseY);
            if (this.isDragged() && this.active) {
                for (UsernameFieldEntry element : this.elements) {
                    if (element == null) continue;
                    element.mouseOver(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.active && mouseButton == 0) {
            for (UsernameFieldEntry element : this.elements) {
                if (element == null || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.setText(element.getDisplayText());
                this.setDragged(false);
                element.setHovered(false);
                if (this.usernameSelectListener != null) {
                    this.usernameSelectListener.select(OxygenHelperClient.getPlayerSharedData(element.getDisplayText()));
                }
                this.active = false;
            }
        }
        return flag;
    }

    private void resetElements() {
        for (int i = 0; i < 5; ++i) {
            this.unbind(this.elements[i]);
            this.elements[i] = null;
        }
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        boolean flag = super.keyTyped(keyChar, keyCode);
        if (flag) {
            String typed = this.getTypedText().toLowerCase();
            if (!typed.isEmpty()) {
                this.resetElements();
                int index = 0;
                for (String username : this.usernames) {
                    if (index > 4) break;
                    String formatted = username.toLowerCase();
                    if (!formatted.startsWith(typed)) continue;
                    this.elements[index] = new UsernameFieldEntry(this.getX(), this.getY() + this.getHeight() * (index + 1), this.getWidth(), this.getHeight(), username);
                    this.bind(this.elements[index]);
                    ++index;
                }
                this.elementsAmount = index;
                this.active = index > 0;
            } else {
                this.active = false;
            }
        }
        return flag;
    }

    public static class UsernameFieldEntry
    extends GUISimpleElement<UsernameFieldEntry> {
        public UsernameFieldEntry(int xPosition, int yPosition, int width, int height, String username) {
            this.setPosition(xPosition, yPosition);
            this.setSize(width, height);
            this.setDisplayText(username);
            this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f);
            this.setStaticBackgroundColor(EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
            this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
            this.enableFull();
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isHovered()) {
                int third = this.getWidth() / 3;
                OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.RIGHT);
                UsernameFieldEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), this.getStaticBackgroundColor());
                OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.LEFT);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @FunctionalInterface
    public static interface UsernameSelectListener {
        public void select(PlayerSharedData var1);
    }
}

