/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class OxygenTexturedButton
extends GUISimpleElement<OxygenTexturedButton> {
    @Nullable
    private MouseClickListener clickListener;
    private final ResourceLocation texture;
    private final int textureWidth;
    private final int textureHeight;

    public OxygenTexturedButton(int xPosition, int yPosition, int buttonWidth, int buttonHeight, ResourceLocation texture, int textureWidth, int textureHeight, String tooltip) {
        this.setPosition(xPosition, yPosition);
        this.setSize(buttonWidth, buttonHeight);
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.setSound(OxygenSoundEffects.BUTTON_CLICK.getSoundEvent());
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt());
        if (!tooltip.isEmpty()) {
            this.initTooltip(tooltip, EnumBaseGUISetting.TOOLTIP_TEXT_COLOR.get().asInt(), EnumBaseGUISetting.TOOLTIP_BACKGROUND_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_TOOLTIP_SCALE.get().asFloat());
        }
        this.enableFull();
    }

    public void setClickListener(MouseClickListener clickListener) {
        this.clickListener = clickListener;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconU = 0;
            if (!this.isEnabled()) {
                iconU = this.textureWidth;
            } else if (this.isHovered() || this.isToggled()) {
                iconU = this.textureWidth * 2;
            }
            GlStateManager.func_179147_l();
            this.mc.func_110434_K().func_110577_a(this.texture);
            GUIAdvancedElement.drawCustomSizedTexturedRect((this.getWidth() - this.textureWidth) / 2, (this.getHeight() - this.textureHeight) / 2, iconU, 0, this.textureWidth, this.textureHeight, this.textureWidth * 3, this.textureHeight);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && this.isHovered() && this.hasTooltip()) {
            int width = this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor()) + 6;
            int height = 8;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.getX() + this.getWidth() / 2 - width / 2), (float)(this.getY() - height - 2), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OxygenTexturedButton.drawRect(0, 0, width, height, this.getTooltipBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, 0.4, height, this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect((double)width - 0.4, 0.0, width, height, this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, width, 0.4, this.getStaticBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, (double)height - 0.4, width, height, this.getStaticBackgroundColor());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((width - this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor())) / 2), (float)((height - this.textHeight(this.getTooltipScaleFactor())) / 2 + 1), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getTooltipText(), 0.0f, 0.0f, this.getTooltipTextColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag) {
            if (this.clickListener != null) {
                this.clickListener.mouseClick(mouseX, mouseY, mouseButton);
            }
            this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
            this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            }
        }
        return flag;
    }

    @FunctionalInterface
    public static interface MouseClickListener {
        public void mouseClick(int var1, int var2, int var3);
    }
}

