/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenTextLabel
extends GUISimpleElement<OxygenTextLabel> {
    private int tooltipFrameColor;

    public OxygenTextLabel(int xPosition, int yPosition, String diplayText, float textScale, int textColorHex, EnumGUIAlignment alignment, int offset, boolean shadow) {
        this.setPosition(xPosition, yPosition);
        this.setSize(1, 6);
        this.setTextScale(textScale);
        this.setDisplayText(diplayText);
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.setEnabledTextColor(textColorHex);
        this.setTextAlignment(alignment, offset);
        if (shadow) {
            this.enableTextShadow();
        }
        this.initTooltip("", EnumBaseGUISetting.TOOLTIP_TEXT_COLOR.get().asInt(), EnumBaseGUISetting.TOOLTIP_BACKGROUND_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_TOOLTIP_SCALE.get().asFloat());
        this.tooltipFrameColor = EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt();
        this.enableFull();
    }

    public OxygenTextLabel(int xPosition, int yPosition, String diplayText, float textScale, int textColorHex) {
        this(xPosition, yPosition, diplayText, textScale, textColorHex, EnumGUIAlignment.LEFT, 0, false);
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() - this.getHeight() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY());
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            int x = this.getTextAlignment() == EnumGUIAlignment.LEFT ? this.getX() : this.getX() - this.textWidth(this.getDisplayText(), this.getTextScale());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            if (this.hasDisplayText()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.getTextOffset(), (float)(-this.textHeight(this.getTextScale())), (float)0.0f);
                GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
                int color = !this.isEnabled() ? this.getDisabledTextColor() : this.getEnabledTextColor();
                this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, color, this.isTextShadowEnabled());
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && this.isHovered() && !this.getTooltipText().isEmpty()) {
            float width = (float)this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor()) + 6.0f;
            float height = 9.0f;
            double frameWidth = 0.4;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)mouseX, (float)((float)mouseY - height), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OxygenTextLabel.drawRect(0, 0, (int)width, (int)height, this.getTooltipBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, frameWidth, height, this.tooltipFrameColor);
            OxygenGUIUtils.drawRect((double)width - frameWidth, 0.0, width, height, this.tooltipFrameColor);
            OxygenGUIUtils.drawRect(0.0, 0.0, width, frameWidth, this.tooltipFrameColor);
            OxygenGUIUtils.drawRect(0.0, (double)height - frameWidth, width, height, this.tooltipFrameColor);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((width - (float)this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor())) / 2.0f), (float)((height - (float)this.textHeight(this.getTooltipScaleFactor())) / 2.0f + 1.0f), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getTooltipText(), 0.0f, 0.0f, this.getTooltipTextColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public OxygenTextLabel setDisplayText(String value) {
        super.setDisplayText(value);
        this.setSize(this.textWidth(value, this.getTextScale()), 6);
        return this;
    }
}

