/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenTextFormattingColorPicker
extends GUISimpleElement<OxygenTextFormattingColorPicker> {
    private static final int[] HEX_COLORS = new int[16];
    @Nullable
    private ColorPickListener colorPickListener;
    private int pickedIndex = -1;

    public OxygenTextFormattingColorPicker(int xPosition, int yPosition) {
        this.setPosition(xPosition, yPosition);
        this.setSize(112, 7);
        this.setSound(OxygenSoundEffects.BUTTON_CLICK.getSoundEvent());
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt());
        this.enableFull();
    }

    public void setColorPickListener(ColorPickListener listener) {
        this.colorPickListener = listener;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < 16; ++i) {
                OxygenTextFormattingColorPicker.drawRect(i * 7, 0, i * 7 + 7, 7, HEX_COLORS[i]);
            }
            if (this.pickedIndex != -1) {
                int frameX = this.pickedIndex * 7;
                OxygenTextFormattingColorPicker.drawRect(frameX - 1, -1, frameX, this.getHeight() + 1, this.getStaticBackgroundColor());
                OxygenTextFormattingColorPicker.drawRect(frameX + 7, -1, frameX + 7 + 1, this.getHeight() + 1, this.getStaticBackgroundColor());
                OxygenTextFormattingColorPicker.drawRect(frameX, -1, frameX + 7, 0, this.getStaticBackgroundColor());
                OxygenTextFormattingColorPicker.drawRect(frameX, this.getHeight(), frameX + 7, this.getHeight() + 1, this.getStaticBackgroundColor());
            }
            if (this.isHovered()) {
                int hoveredIndex = (mouseX - this.getX()) / 7;
                OxygenTextFormattingColorPicker.drawRect((hoveredIndex *= 7) - 1, -1, hoveredIndex, this.getHeight() + 1, this.getStaticBackgroundColor());
                OxygenTextFormattingColorPicker.drawRect(hoveredIndex + 7, -1, hoveredIndex + 7 + 1, this.getHeight() + 1, this.getStaticBackgroundColor());
                OxygenTextFormattingColorPicker.drawRect(hoveredIndex, -1, hoveredIndex + 7, 0, this.getStaticBackgroundColor());
                OxygenTextFormattingColorPicker.drawRect(hoveredIndex, this.getHeight(), hoveredIndex + 7, this.getHeight() + 1, this.getStaticBackgroundColor());
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag) {
            this.pickedIndex = (mouseX - this.getX()) / 7;
            if (this.colorPickListener != null) {
                this.colorPickListener.pick(this.pickedIndex);
            }
        }
        return flag;
    }

    public int getPickedColorIndex() {
        return this.pickedIndex;
    }

    public void setPickedColorIndex(int index) {
        this.pickedIndex = index;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int m = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            OxygenTextFormattingColorPicker.HEX_COLORS[i] = 0xFF000000 | (k & 0xFF) << 16 | (l & 0xFF) << 8 | m & 0xFF;
        }
    }

    @FunctionalInterface
    public static interface ColorPickListener {
        public void pick(int var1);
    }
}

