/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenSectionSwitcher
extends GUISimpleElement<OxygenSectionSwitcher> {
    private final OxygenSectionsSwitcherEntry[] elements;
    @Nullable
    private SectionChangeListener sectionChangeListener;

    public OxygenSectionSwitcher(int xPosition, int yPosition, AbstractGUISection ... sections) {
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat());
        this.setDisplayText(sections[0].getDisplayText());
        int width = 0;
        for (AbstractGUISection section : sections) {
            int textWidth = this.textWidth(section.getDisplayText(), this.getTextScale());
            if (width != 0 && width >= textWidth) continue;
            width = textWidth;
        }
        this.setSize(width + 8, 9);
        this.setPosition(xPosition - this.getWidth(), yPosition);
        this.elements = new OxygenSectionsSwitcherEntry[sections.length];
        int index = 0;
        for (AbstractGUISection section : sections) {
            int n = index++;
            OxygenSectionsSwitcherEntry oxygenSectionsSwitcherEntry = new OxygenSectionsSwitcherEntry(this.getX(), this.getY() + index * 9 + 2, this.getWidth(), 9, section);
            this.elements[n] = oxygenSectionsSwitcherEntry;
            this.bind(oxygenSectionsSwitcherEntry);
        }
        this.setDynamicBackgroundColor(EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt(), EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt(), 0);
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.enableFull();
    }

    public void setSectionChangeListener(SectionChangeListener listener) {
        this.sectionChangeListener = listener;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragged()) {
                int size = this.elements.length + 1;
                OxygenSectionSwitcher.drawRect(0, this.getHeight() + 2, this.getWidth(), this.getHeight() * size + 2, this.getEnabledBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, (double)this.getHeight() + 2.0, 0.4, (double)(this.getHeight() * size) + 1.6, this.getDisabledBackgroundColor());
                OxygenGUIUtils.drawRect((double)this.getWidth() - 0.4, (double)this.getHeight() + 2.0, this.getWidth(), (double)(this.getHeight() * size) + 1.6, this.getDisabledBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, (double)this.getHeight() + 1.6, this.getWidth(), (double)this.getHeight() + 2.0, this.getDisabledBackgroundColor());
                OxygenGUIUtils.drawRect(0.0, (float)(this.getHeight() * size) + 2.4f, this.getWidth(), (double)(this.getHeight() * size) + 2.0, this.getDisabledBackgroundColor());
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 1.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconU = 0;
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                iconU = 3;
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered() && !this.isDragged()) {
                iconU = 6;
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.SORT_DOWN_ICONS);
            GUIAdvancedElement.drawCustomSizedTexturedRect(this.textWidth(this.getDisplayText(), this.getTextScale()) + 4, (this.getHeight() - 3) / 2 + 1, iconU, 0, 3, 3, 9, 3);
            GlStateManager.func_179121_F();
            if (this.isDragged()) {
                for (OxygenSectionsSwitcherEntry element : this.elements) {
                    element.draw(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            this.setHovered(mouseX >= this.getX() && mouseY >= this.getY() && mouseX <= this.getX() + (int)(this.getScale() * (float)this.getWidth()) && mouseY < this.getY() + (int)(this.getScale() * (float)(this.isDragged() ? this.getHeight() * (this.elements.length + 1) : this.getHeight())));
            if (this.isDragged()) {
                for (OxygenSectionsSwitcherEntry element : this.elements) {
                    element.mouseOver(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && mouseButton == 0) {
            for (OxygenSectionsSwitcherEntry element : this.elements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.setDragged(false);
                element.setHovered(false);
                if (this.sectionChangeListener != null) {
                    this.sectionChangeListener.change(element.section);
                }
                if (this.screen.getWorkspace().getCurrentSection() != element.section) {
                    element.section.open();
                }
                this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.CONTEXT_CLOSE.getSoundEvent(), 0.5f, 1.0f);
                return true;
            }
        }
        if (flag && mouseButton == 0 && !this.isDragged()) {
            this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.DROP_DOWN_LIST_OPEN.getSoundEvent(), 0.5f, 1.0f);
        }
        this.setDragged(flag && mouseButton == 0);
        return false;
    }

    public static class OxygenSectionsSwitcherEntry
    extends GUISimpleElement<OxygenSectionsSwitcherEntry> {
        public final AbstractGUISection section;

        public OxygenSectionsSwitcherEntry(int xPosition, int yPosition, int width, int height, AbstractGUISection section) {
            this.section = section;
            this.setPosition(xPosition, yPosition);
            this.setSize(width, height);
            this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat());
            this.setStaticBackgroundColor(EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
            this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
            this.setEnabled(section.isEnabled());
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isHovered()) {
                int third = this.getWidth() / 3;
                OxygenGUIUtils.drawGradientRect(0.0, 0.0, third, this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.RIGHT);
                OxygenSectionsSwitcherEntry.drawRect(third, 0, this.getWidth() - third, this.getHeight(), this.getStaticBackgroundColor());
                OxygenGUIUtils.drawGradientRect(this.getWidth() - third, 0.0, this.getWidth(), this.getHeight(), 0, this.getStaticBackgroundColor(), EnumGUIAlignment.LEFT);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)2.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.section.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @FunctionalInterface
    public static interface SectionChangeListener {
        public void change(AbstractGUISection var1);
    }
}

