/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;

public class OxygenKeyButton
extends GUISimpleElement<OxygenKeyButton> {
    @Nullable
    private MouseClickListener mouseClickListener;
    @Nonnull
    private final KeyboardKeyPressListener keyListener;
    private final int keyCode;
    private final String keyStr;

    public OxygenKeyButton(int xPosition, int yPosition, String displayText, int keyCode, KeyboardKeyPressListener listener) {
        this.setPosition(xPosition, yPosition);
        this.setSize(10, 8);
        this.setTextScale(EnumBaseGUISetting.TEXT_BUTTON_SCALE.get().asFloat());
        this.setStaticBackgroundColor(EnumBaseGUISetting.BACKGROUND_BASE_COLOR.get().asInt());
        this.setDynamicBackgroundColor(EnumBaseGUISetting.BUTTON_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.BUTTON_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.BUTTON_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.setDebugColor(EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt());
        this.setSound(OxygenSoundEffects.BUTTON_CLICK.getSoundEvent());
        this.keyCode = keyCode;
        this.keyListener = listener;
        Object[] objectArray = new Object[1];
        ClientReference.getGameSettings();
        objectArray[0] = GameSettings.func_74298_c((int)this.keyCode);
        this.keyStr = String.format("[%s]", objectArray);
        this.setDisplayText(displayText);
        this.enableFull();
    }

    public void setClickListener(MouseClickListener clickListener) {
        this.mouseClickListener = clickListener;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag) {
            if (this.mouseClickListener != null) {
                this.mouseClickListener.click(mouseX, mouseY, mouseButton);
            }
            this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
            this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            }
        }
        return flag;
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        if (this.isEnabled() && keyCode == this.keyCode) {
            this.keyListener.press();
        }
        return false;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = this.getEnabledBackgroundColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredBackgroundColor();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(this.getWidth() - this.textWidth(this.keyStr, this.getTextScale())) / 2.0f), (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            color = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                color = this.getDisabledTextColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.keyStr, 0.0f, 0.0f, color, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.getWidth() + 2.0f), (float)((float)(this.getHeight() - this.textHeight(this.getTextScale())) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, this.getDebugColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @FunctionalInterface
    public static interface KeyboardKeyPressListener {
        public void press();
    }

    @FunctionalInterface
    public static interface MouseClickListener {
        public void click(int var1, int var2, int var3);
    }
}

