/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.InventoryProviderClient;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenInventoryLoad
extends GUISimpleElement<OxygenInventoryLoad> {
    private int occupied;
    private int tooltipFrameColor;
    private boolean overloaded;

    public OxygenInventoryLoad(int xPosition, int yPosition) {
        this.setPosition(xPosition, yPosition);
        this.setSize(1, 6);
        this.setTextScale(EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f);
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt(), 0);
        this.setStaticBackgroundColor(EnumBaseGUISetting.INACTIVE_TEXT_COLOR.get().asInt());
        this.initTooltip(ClientReference.localize("oxygen_core.gui.inventoryLoad", new Object[0]), EnumBaseGUISetting.TOOLTIP_TEXT_COLOR.get().asInt(), EnumBaseGUISetting.TOOLTIP_BACKGROUND_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_TOOLTIP_SCALE.get().asFloat());
        this.tooltipFrameColor = EnumBaseGUISetting.BACKGROUND_ADDITIONAL_COLOR.get().asInt();
        this.enableFull();
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)((float)this.getY() - ((float)this.getHeight() - (float)this.textHeight(this.getTextScale())) / 2.0f + 1.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, this.overloaded ? this.getStaticBackgroundColor() : this.getEnabledTextColor(), false);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && this.isHovered() && this.hasTooltip()) {
            float width = (float)this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor()) + 6.0f;
            float height = 9.0f;
            double frameWidth = 0.4;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.getX() + (float)this.getWidth() / 2.0f - width / 2.0f), (float)((float)this.getY() - height - 3.0f), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OxygenInventoryLoad.drawRect(0, 0, (int)width, (int)height, this.getTooltipBackgroundColor());
            OxygenGUIUtils.drawRect(0.0, 0.0, frameWidth - 0.1, height, this.tooltipFrameColor);
            OxygenGUIUtils.drawRect((double)width - frameWidth, 0.0, width, height, this.tooltipFrameColor);
            OxygenGUIUtils.drawRect(0.0, 0.0, width, frameWidth, this.tooltipFrameColor);
            OxygenGUIUtils.drawRect(0.0, (double)height - frameWidth, width, height, this.tooltipFrameColor);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((width - (float)this.textWidth(this.getTooltipText(), this.getTooltipScaleFactor())) / 2.0f), (float)((height - (float)this.textHeight(this.getTooltipScaleFactor())) / 2.0f + 1.0f), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)this.getTooltipScaleFactor(), (float)this.getTooltipScaleFactor(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getTooltipText(), 0.0f, 0.0f, this.getTooltipTextColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    public void setLoad(int occupiedSlots) {
        int size = InventoryProviderClient.getPlayerInventory().getSize(ClientReference.getClientPlayer());
        this.occupied = occupiedSlots;
        this.overloaded = occupiedSlots == size;
        this.setDisplayText(String.format("%s/%s", occupiedSlots, size));
        this.setSize(this.textWidth(this.getDisplayText(), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.05f), 6);
    }

    public void updateLoad() {
        this.setLoad(InventoryProviderClient.getPlayerInventory().getOccupiedSlotsAmount(ClientReference.getClientPlayer()));
    }

    public void decrementLoad(int value) {
        this.setLoad(this.occupied - value);
    }

    public void incrementtLoad(int value) {
        this.setLoad(this.occupied + value);
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    public int getLoad() {
        return this.occupied;
    }
}

